/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.jcr.grouping.Duration;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskArchive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class Top5LongestRunningDeployments
extends DashboardWidgetBase {
    private static final String DURATIONLIST = "durationList";
    private static final String DURATION = "duration";
    private static final String ENVIRONMENT = "environment";
    private static final String APPLICATION_NAME = "applicationName";

    private Top5LongestRunningDeployments(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public static final Widget getInstance(TaskArchive taskArchive) {
        return new Top5LongestRunningDeployments(taskArchive);
    }

    @Override
    public Report getReport(Date date, Date date2) {
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters();
        archivedTaskSearchParameters.createdBetween(date.getCalendar(), date2.getCalendar()).thatCompleted();
        Collection collection = this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new GroupBy((Collection)Lists.newArrayList((Object[])new String[]{APPLICATION_NAME, ENVIRONMENT}), new Function[]{new Duration(DURATIONLIST)}));
        return this.generateDurationReport(collection);
    }

    Report generateDurationReport(Collection<Map<String, Object>> collection) {
        this.calculateAverageDurations(collection);
        ArrayList arrayList = Lists.newArrayList(collection);
        Collections.sort(arrayList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> map, Map<String, Object> map2) {
                Long l = (Long)map.get(Top5LongestRunningDeployments.DURATION);
                Long l2 = (Long)map2.get(Top5LongestRunningDeployments.DURATION);
                return -l.compareTo(l2);
            }
        });
        Report report = new Report();
        for (Map map : arrayList.subList(0, Math.min(5, collection.size()))) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue(APPLICATION_NAME, map.get(APPLICATION_NAME));
            reportLine.addValue("environmentName", map.get(ENVIRONMENT));
            reportLine.addValue(DURATION, (Object)this.formatToMinsAndSecs((Long)map.get(DURATION)));
        }
        return report;
    }

    private void calculateAverageDurations(Collection<Map<String, Object>> collection) {
        for (Map<String, Object> map : collection) {
            List list = (List)map.get(DURATIONLIST);
            long l = 0L;
            for (Long l2 : list) {
                l += l2.longValue();
            }
            map.put(DURATION, l / (long)list.size());
        }
    }
}

