/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Splitter;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.TaskProxy;
import com.xebialabs.deployit.core.api.dto.FullTaskInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.TaskRegistry;
import com.xebialabs.deployit.task.TaskStep;
import com.xebialabs.deployit.task.TaskStepInfo;
import java.util.Calendar;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class TaskResource
extends AbstractSecuredResource
implements TaskProxy {
    @Autowired
    private DtoWriter dtoConverter;
    @Autowired
    private ExecutionEngine engine;
    @Autowired
    private TaskRegistry taskRegistry;
    @Autowired
    private TaskArchive taskArchive;
    private static final Logger logger = LoggerFactory.getLogger(TaskResource.class);

    public Response start(String string) {
        this.engine.execute(string);
        return ResponseFactory.accepted().build();
    }

    public Response cancel(String string) {
        this.engine.cancel(string);
        return ResponseFactory.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response stop(String string) {
        try {
            this.engine.stopExecution(string);
        }
        catch (IllegalStateException illegalStateException) {
            logger.error(String.format("Could not stop task %s", string), (Throwable)illegalStateException);
            return ResponseFactory.status((Response.Status)Response.Status.CONFLICT).entity((Object)illegalStateException.getMessage()).build();
        }
        return ResponseFactory.accepted().build();
    }

    public Response abort(String string) {
        try {
            this.engine.abortExecution(string);
        }
        catch (IllegalStateException illegalStateException) {
            logger.error(String.format("Could not abort task %s", string), (Throwable)illegalStateException);
            return ResponseFactory.status((Response.Status)Response.Status.CONFLICT).entity((Object)illegalStateException.getMessage()).build();
        }
        return ResponseFactory.accepted().build();
    }

    public Response getTaskInfo(String string) {
        Task task = this.taskRegistry.getTask(string);
        TaskInfo taskInfo = task != null ? this.dtoConverter.taskToDto(task) : this.dtoConverter.archivedTaskToDto(this.taskArchive.getTask(string));
        return ResponseFactory.ok((Object)taskInfo).build();
    }

    public Response assignTask(@PathParam(value="taskid") String string, @PathParam(value="owner") String string2) {
        Task task = this.taskRegistry.getTask(string);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{string});
        if (this.hasPermission(Permission.ADMIN)) {
            this.taskRegistry.assignTask(string, string2);
        } else if (this.hasPermission(Permission.TASK_ASSIGN)) {
            this.taskRegistry.assignMyTask(string, string2);
        } else {
            throw PermissionDeniedException.withMessage((String)"Neither ADMIN nor TASK_ASSIGN permissions are granted to you or you are not the owner of the task");
        }
        return ResponseFactory.ok().build();
    }

    public Response toggleSkipSteps(@PathParam(value="taskid") String string, @PathParam(value="steps") String string2) {
        Task task = this.taskRegistry.getTask(string);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{string});
        if (!this.checkPermission(Permission.TASK_SKIPSTEP, task)) {
            throw new Checks.IncorrectArgumentException("Can only skip steps on a deployment task", new Object[0]);
        }
        Iterable iterable = Splitter.on((String)",").split((CharSequence)string2);
        for (String string3 : iterable) {
            int n = Integer.parseInt(string3);
            TaskStep taskStep = task.getStep(n);
            if (taskStep.canSkip()) {
                logger.info("Skipping step :{}", (Object)taskStep.getDescription());
                taskStep.skip();
                continue;
            }
            if (!taskStep.isSkipped()) continue;
            taskStep.unskip();
        }
        return ResponseFactory.ok((Object)this.dtoConverter.fullTaskToDto(task)).build();
    }

    private boolean checkPermission(Permission permission, Task task) {
        if (task instanceof DeploymentTask) {
            String string = ((DeploymentTask)task).getEnvironmentId();
            this.checkPermission(permission, string);
            return true;
        }
        return false;
    }

    public Response moveStep(@PathParam(value="taskid") String string, @PathParam(value="stepNr") int n, @PathParam(value="position") int n2) {
        Task task = this.taskRegistry.getTask(string);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{string});
        if (!this.checkPermission(Permission.TASK_MOVESTEP, task)) {
            throw new Checks.IncorrectArgumentException("Can only move steps on a deployment task", new Object[0]);
        }
        task.moveStep(n, n2);
        return ResponseFactory.ok((Object)this.dtoConverter.fullTaskToDto(task)).build();
    }

    public Response getStepInfo(String string, int n, Date date) {
        TaskStep taskStep;
        Task task = this.taskRegistry.getTask(string);
        if (task != null) {
            taskStep = task.getStep(n);
        } else {
            DeploymentTaskInfo deploymentTaskInfo = this.taskArchive.getTask(string);
            taskStep = deploymentTaskInfo.getStep(n);
        }
        if (this.hasBeenModifiedSince((TaskStepInfo)taskStep, date)) {
            return ResponseFactory.ok((Object)this.dtoConverter.taskStepInfoToDto(n, (TaskStepInfo)taskStep)).lastModified(taskStep.getLastModificationDate().getTime()).build();
        }
        return ResponseFactory.notModified().build();
    }

    protected boolean hasBeenModifiedSince(TaskStepInfo taskStepInfo, Date date) {
        if (date == null) {
            return true;
        }
        Calendar calendar = taskStepInfo.getLastModificationDate();
        calendar.set(14, 0);
        return date.getCalendar().before(calendar);
    }

    public Response getUnfinishedTasks() {
        return ResponseFactory.ok((Object)this.dtoConverter.tasksToDto(this.engine.getAllIncompleteTasksForCurrentUser())).build();
    }

    public Response getAllUnfinishedTasks() {
        this.checkPermission(Permission.ADMIN);
        return ResponseFactory.ok((Object)this.dtoConverter.tasksToDto(this.engine.getAllIncompleteTasks())).build();
    }

    public Response getStepsForTask(String string) {
        Task task = this.taskRegistry.getTask(string);
        FullTaskInfo fullTaskInfo = task != null ? this.dtoConverter.fullTaskToDto(task) : this.dtoConverter.fullArchivedTaskToDto(this.taskArchive.getTask(string));
        return ResponseFactory.ok((Object)fullTaskInfo).build();
    }
}

