/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.ServerProxy;
import com.xebialabs.deployit.core.api.dto.ServerInfo;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.event.Event;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import java.io.IOException;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;

@Controller
public class ServerResource
extends AbstractSecuredResource
implements ServerProxy {
    @Autowired
    private GarbageCollectionService garbageCollectionService;

    public Response shutdown() {
        this.checkPermission(Permission.ADMIN);
        EventBus.publish((Event)new ShutdownEvent());
        return ResponseFactory.noContent().build();
    }

    public Response getInfo() {
        ClassPathResource classPathResource = new ClassPathResource("com/xebialabs/deployit/release.properties");
        Properties properties = new Properties();
        try {
            properties.load(classPathResource.getInputStream());
            ServerInfo serverInfo = new ServerInfo();
            serverInfo.setVersion(properties.getProperty("version"));
            return ResponseFactory.ok((Object)serverInfo).build();
        }
        catch (IOException iOException) {
            throw new DeployitException((Throwable)iOException);
        }
    }

    public Response gc() {
        this.garbageCollectionService.runGarbageCollector();
        return ResponseFactory.noContent().build();
    }
}

