/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.DeploymentProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.Deployment;
import com.xebialabs.deployit.core.api.dto.FullTaskInfo;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoReader;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoWriter;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeployedService;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DeploymentResource
extends AbstractSecuredResource
implements DeploymentProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private DeployedService deployedService;
    @Autowired
    private ConfigurationItemDtoWriter dtoWriter;
    @Autowired
    private ConfigurationItemDtoReader dtoReader;
    @Autowired
    private DtoWriter dtoConverter;
    @Autowired
    private ExecutionEngine engine;
    @Autowired
    private Validator validator;
    @Autowired
    private WorkDirFactory workDirFactory;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);

    public Response prepareInitial(@QueryParam(value="version") String string, @QueryParam(value="environment") String string2) {
        logger.trace("prepareInitial {}, {}", (Object)string, (Object)string2);
        this.checkPermission(Permission.DEPLOY_INITIAL, string2);
        Checks.checkNotNull((Object)string, (String)"version");
        Checks.checkNotNull((Object)string2, (String)"environment");
        ConfigurationItem configurationItem = this.repositoryService.read(string);
        ConfigurationItem configurationItem2 = this.repositoryService.read(string2);
        Checks.checkArgument((boolean)(configurationItem instanceof Version), (String)"%s is not a Version", (Object[])new Object[]{string});
        Checks.checkArgument((boolean)(configurationItem2 instanceof Environment), (String)"%s is not an Environment", (Object[])new Object[]{string2});
        Deployment deployment = this.createDeployment((Version)configurationItem, (Environment)configurationItem2);
        return ResponseFactory.ok((Object)deployment).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response prepareUpgrade(@QueryParam(value="version") String string, @QueryParam(value="deployedApplication") String string2) {
        logger.trace("prepareUpgrade {}, {}", (Object)string, (Object)string2);
        Checks.checkNotNull((Object)string, (String)"version");
        Checks.checkNotNull((Object)string2, (String)"deployedApplication");
        WorkDir workDir = this.workDirFactory.newWorkDir();
        WorkDir workDir2 = this.workDirFactory.newWorkDir();
        try {
            ConfigurationItem configurationItem = this.repositoryService.read(string2, workDir);
            Checks.checkArgument((boolean)(configurationItem instanceof DeployedApplication), (String)"%s is not a DeployedApplication", (Object[])new Object[]{string2});
            Environment environment = ((DeployedApplication)configurationItem).getEnvironment();
            this.checkPermission(Permission.DEPLOY_UPGRADE, environment.getId());
            ConfigurationItem configurationItem2 = this.repositoryService.read(string, workDir2);
            Checks.checkArgument((boolean)(configurationItem2 instanceof Version), (String)"%s is not a Version", (Object[])new Object[]{string});
            ListMultimap listMultimap = this.deployedService.generateUpgradedDeployeds((Version)configurationItem2, (DeployedApplication)configurationItem);
            DeployedApplication deployedApplication = (DeployedApplication)configurationItem;
            deployedApplication.setDeployeds((Set)Sets.newHashSet());
            deployedApplication.setVersion((Version)configurationItem2);
            Deployment deployment = new Deployment();
            deployment.setDeployedApplication(this.dtoWriter.write((ConfigurationItem)deployedApplication));
            deployment.setUpgrade(true);
            deployment.setDeployeds(this.dtoWriter.write((ListMultimap<Boolean, ConfigurationItem>)listMultimap));
            Response response = ResponseFactory.ok((Object)deployment).build();
            return response;
        }
        finally {
            workDir.delete();
            workDir2.delete();
        }
    }

    public Response prepareUndeployApplication(String string) {
        logger.trace("prepareUndeployApplication {}", (Object)string);
        Checks.checkNotNull((Object)string, (String)"deployedApplication");
        ConfigurationItem configurationItem = this.repositoryService.read(string);
        Checks.checkArgument((boolean)(configurationItem instanceof DeployedApplication), (String)"%s is not a DeployedApplication", (Object[])new Object[]{string});
        DeployedApplication deployedApplication = (DeployedApplication)configurationItem;
        this.checkPermission(Permission.UNDEPLOY, deployedApplication.getEnvironment().getId());
        Deployment deployment = this.createDeployment(deployedApplication);
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response generateAllDeployeds(Deployment deployment) {
        logger.trace("generateAllDeployeds {}", (Object)deployment);
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(Permission.DEPLOY_INITIAL, deployment.getEnvironment());
        Version version = (Version)this.repositoryService.read(deployment.getVersion());
        Environment environment = (Environment)this.repositoryService.read(deployment.getEnvironment());
        ListMultimap listMultimap = this.deployedService.generateAllDeployeds(version, environment);
        deployment.addAll(this.dtoWriter.write((ListMultimap<Boolean, ConfigurationItem>)listMultimap));
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response generateSelectedDeployeds(@QueryParam(value="deployables") List<String> list, Deployment deployment) {
        logger.trace("generateSelectedDeployeds {}, {}", list, (Object)deployment);
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(Permission.DEPLOY_INITIAL, deployment.getEnvironment());
        Checks.checkArgument((list.size() > 0 ? 1 : 0) != 0, (String)"Should select at least one deployable to generate a deployed", (Object[])new Object[0]);
        Version version = (Version)this.repositoryService.read(deployment.getVersion());
        ImmutableMap immutableMap = Maps.uniqueIndex((Iterable)version.getDeployables(), (Function)new Function<Deployable, String>(){

            public String apply(Deployable deployable) {
                return deployable.getId();
            }
        });
        Environment environment = (Environment)this.repositoryService.read(deployment.getEnvironment());
        ArrayList arrayList = Lists.newArrayList();
        for (String string : list) {
            Checks.checkArgument((boolean)immutableMap.containsKey(string), (String)"All sources should be from same package", (Object[])new Object[0]);
            arrayList.add(immutableMap.get(string));
        }
        ListMultimap listMultimap = this.deployedService.generateSelectedDeployeds((List)arrayList, environment);
        deployment.addAll(this.dtoWriter.write((ListMultimap<Boolean, ConfigurationItem>)listMultimap));
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response generateSingleDeployed(@QueryParam(value="deployable") String string, @QueryParam(value="container") String string2, @QueryParam(value="deployedtype") String string3, Deployment deployment) {
        logger.debug("Creating explicit deployed for [{}] and [{}]", (Object)string, (Object)string2);
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(Permission.DEPLOY_INITIAL, deployment.getEnvironment());
        Checks.checkNotNull((Object)string, (String)"deployable");
        Checks.checkNotNull((Object)string2, (String)"container");
        ConfigurationItem configurationItem = this.repositoryService.read(string);
        Checks.checkArgument((boolean)(configurationItem instanceof Deployable), (String)"%s should be a Deployable.", (Object[])new Object[]{string});
        ConfigurationItem configurationItem2 = this.repositoryService.read(string2);
        Checks.checkArgument((boolean)(configurationItem2 instanceof Container), (String)"%s should be a Container.", (Object[])new Object[]{string2});
        Environment environment = (Environment)this.repositoryService.read(deployment.getEnvironment());
        ListMultimap listMultimap = this.deployedService.createSelectedDeployed((Deployable)configurationItem, (Container)configurationItem2, string3, environment);
        deployment.addAll(this.dtoWriter.write((ListMultimap<Boolean, ConfigurationItem>)listMultimap));
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response validate(Deployment deployment) {
        if (!this.validateDeploymentWithValidator(deployment)) {
            return ResponseFactory.badRequest((Object)deployment).build();
        }
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response deploy(Deployment deployment) {
        logger.trace("deploy {}", (Object)deployment);
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        Task task = this.createDeploymentTask(deployment);
        String string = this.engine.register(task);
        FullTaskInfo fullTaskInfo = this.dtoConverter.fullTaskToDto(task);
        return ResponseFactory.ok((Object)fullTaskInfo).build();
    }

    public Response undeploy(String string) {
        WorkDir workDir = this.workDirFactory.newWorkDir();
        try {
            Checks.checkNotNull((Object)string, (String)"deployedApplication");
            ConfigurationItem configurationItem = this.repositoryService.read(string, workDir);
            Checks.checkArgument((boolean)(configurationItem instanceof DeployedApplication), (String)"%s is not a DeployedApplication", (Object[])new Object[]{string});
            this.checkPermission(Permission.UNDEPLOY, ((DeployedApplication)configurationItem).getEnvironment().getId());
            Task task = this.deploymentService.prepareUndeployment((DeployedApplication)configurationItem, workDir);
            String string2 = this.engine.register(task);
            FullTaskInfo fullTaskInfo = this.dtoConverter.fullTaskToDto(task);
            return ResponseFactory.ok((Object)fullTaskInfo).build();
        }
        catch (RuntimeException runtimeException) {
            workDir.delete();
            throw runtimeException;
        }
    }

    public Response undeployApplication(Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        Environment environment = (Environment)this.repositoryService.read(deployment.getEnvironment());
        this.checkPermission(Permission.UNDEPLOY, environment.getId());
        WorkDir workDir = this.workDirFactory.newWorkDir();
        try {
            DeployedApplication deployedApplication = (DeployedApplication)this.dtoReader.read(deployment.getDeployedApplication(), workDir);
            Task task = this.deploymentService.prepareUndeployment(deployedApplication, workDir);
            String string = this.engine.register(task);
            logger.trace("Registered undeployment task {} for Deployed Application {}", (Object)string, (Object)deployment.getDeployedApplication().getId());
            FullTaskInfo fullTaskInfo = this.dtoConverter.fullTaskToDto(task);
            return ResponseFactory.ok((Object)fullTaskInfo).build();
        }
        catch (RuntimeException runtimeException) {
            workDir.delete();
            throw runtimeException;
        }
    }

    private Task createDeploymentTask(Deployment deployment) {
        Task task;
        block5: {
            WorkDir workDir = this.workDirFactory.newWorkDir();
            task = null;
            try {
                DeployedApplication deployedApplication = (DeployedApplication)this.dtoReader.read(deployment.getDeployedApplication(), workDir);
                if (!deployment.isUpgrade()) {
                    List<ConfigurationItem> list = this.dtoReader.read(deployment.getDeployeds(), workDir);
                    task = this.deploymentService.prepareInitialDeployment(deployedApplication, this.toDeployeds(list), workDir);
                    break block5;
                }
                WorkDir workDir2 = this.workDirFactory.newWorkDir();
                try {
                    List<ConfigurationItem> list = this.dtoReader.read(deployment.getDeployeds(), workDir);
                    DeployedApplication deployedApplication2 = (DeployedApplication)this.repositoryService.read(deployment.getDeployedApplication().getId(), workDir2);
                    task = this.deploymentService.prepareUpgradeDeployment(deployedApplication, deployedApplication2, this.toDeployeds(list), workDir2, workDir);
                }
                catch (RuntimeException runtimeException) {
                    workDir2.delete();
                    throw runtimeException;
                }
            }
            catch (RuntimeException runtimeException) {
                workDir.delete();
                throw runtimeException;
            }
        }
        return task;
    }

    private Collection<Deployed> toDeployeds(Collection<ConfigurationItem> collection) {
        return Collections2.transform(collection, (Function)new Function<ConfigurationItem, Deployed>(){

            public Deployed apply(ConfigurationItem configurationItem) {
                Checks.checkArgument((boolean)(configurationItem instanceof Deployed), (String)"%s should be a Deployed", (Object[])new Object[]{configurationItem.getId()});
                return (Deployed)configurationItem;
            }
        });
    }

    private boolean validateDeploymentWithValidator(Deployment deployment) {
        Object t = this.dtoReader.read(deployment.getDeployedApplication());
        List list = this.validator.validate(t, Collections.EMPTY_LIST);
        Iterable iterable = Iterables.filter((Iterable)list, (Predicate)new Predicate<ValidationMessage>(){

            public boolean apply(ValidationMessage validationMessage) {
                return validationMessage.getPropertyName() != "deployeds";
            }
        });
        if (Iterables.size((Iterable)iterable) > 0) {
            deployment.getDeployedApplication().setValidations(this.dtoWriter.write((ConfigurationItem)t, iterable).getValidations());
            return false;
        }
        return this.validateDeployedsWithValidator(deployment.getDeployeds());
    }

    private boolean validateDeployedsWithValidator(List<ConfigurationItemDto> list) {
        boolean bl = true;
        List<ConfigurationItem> list2 = this.dtoReader.read(list);
        for (int i = 0; i < list.size(); ++i) {
            ConfigurationItemDto configurationItemDto = list.get(i);
            ConfigurationItem configurationItem = list2.get(i);
            List list3 = this.validator.validate(configurationItem, list2);
            if (list3.isEmpty()) continue;
            configurationItemDto.setValidations(this.dtoWriter.write(configurationItem, list3).getValidations());
            bl = false;
        }
        return bl;
    }

    private Deployment createDeployment(Version version, Environment environment) {
        DeployedApplication deployedApplication = (DeployedApplication)DescriptorRegistry.getDescriptor((Type)Type.valueOf(DeployedApplication.class)).newInstance();
        deployedApplication.setVersion(version);
        deployedApplication.setEnvironment(environment);
        IdGenerator.generateId((DeployedApplication)deployedApplication);
        return this.createDeployment(deployedApplication);
    }

    private Deployment createDeployment(DeployedApplication deployedApplication) {
        Deployment deployment = new Deployment();
        deployment.setDeployedApplication(this.dtoWriter.write((ConfigurationItem)deployedApplication));
        return deployment;
    }
}

