/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DeploymentsPercentageWidgetData
extends DashboardWidgetBase {
    private DeploymentsPercentageWidgetData(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public static final Widget getInstance(TaskArchive taskArchive) {
        return new DeploymentsPercentageWidgetData(taskArchive);
    }

    @Override
    public Report getReport(Date date, Date date2) {
        return this.generateReportData(this.groupCompletedTasksByState(new ArchivedTaskSearchParameters().createdBetween(date.getCalendar(), date2.getCalendar())));
    }

    private Report generateReportData(TaskStateData taskStateData) {
        Report report = new Report();
        if (taskStateData.getTotalTasks() == 0) {
            return report;
        }
        Report.ReportLine reportLine = report.addLine();
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        reportLine.addValue("noOfSuccessfulDeployments", (Object)decimalFormat.format(this.getPercentage(taskStateData.getNoOfSuccessfulDeployments().get(), taskStateData.getTotalTasks())));
        reportLine.addValue("noOfAbortedDeployments", (Object)decimalFormat.format(this.getPercentage(taskStateData.getNoOfAbortedDeployments().get(), taskStateData.getTotalTasks())));
        reportLine.addValue("noOfFailedDeployments", (Object)decimalFormat.format(this.getPercentage(taskStateData.getNoOfFailedDeployments().get(), taskStateData.getTotalTasks())));
        return report;
    }

    private TaskStateData groupCompletedTasksByState(ArchivedTaskSearchParameters archivedTaskSearchParameters) {
        final TaskStateData taskStateData = new TaskStateData();
        this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new JcrTaskArchive.TaskCallback(){

            public void doWithTask(DeploymentTaskInfo deploymentTaskInfo) {
                switch (deploymentTaskInfo.getState()) {
                    case DONE: {
                        if (deploymentTaskInfo.getFailureCount() == 0) {
                            taskStateData.getNoOfSuccessfulDeployments().incrementAndGet();
                            break;
                        }
                        taskStateData.getNoOfFailedDeployments().incrementAndGet();
                        break;
                    }
                    case CANCELLED: {
                        taskStateData.getNoOfAbortedDeployments().incrementAndGet();
                    }
                }
            }
        });
        return taskStateData;
    }
}

