/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.RepositoryProxy;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoReader;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class RepositoryResource
extends AbstractSecuredResource
implements RepositoryProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ConfigurationItemDtoReader dtoReader;
    @Autowired
    private ConfigurationItemDtoWriter dtoWriter;
    @Autowired
    private Validator validator;
    @Autowired
    private WorkDirFactory workDirFactory;

    public Response create(String string, ConfigurationItemDto configurationItemDto) {
        this.checkPermission(Permission.EDIT_REPO, string);
        configurationItemDto.setId(string);
        Object t = this.dtoReader.read(configurationItemDto);
        return this.createInternal((ConfigurationItem)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response create(String string, ArtifactAndData artifactAndData) {
        this.checkPermission(Permission.EDIT_REPO, string);
        artifactAndData.getArtifact().setId(string);
        WorkDir workDir = this.workDirFactory.newWorkDir();
        try {
            ConfigurationItem configurationItem = this.dtoReader.read(artifactAndData, workDir);
            Response response = this.createInternal(configurationItem);
            return response;
        }
        finally {
            workDir.delete();
        }
    }

    public Response createMultiple(ConfigurationItemDtos configurationItemDtos) {
        List list = Lists.transform((List)configurationItemDtos.getObjects(), (Function)new Function<RepositoryObject, String>(){

            public String apply(RepositoryObject repositoryObject) {
                return repositoryObject.getId();
            }
        });
        for (String string : list) {
            this.checkPermission(Permission.EDIT_REPO, string);
        }
        return this.createInternal(this.dtoReader.read(configurationItemDtos));
    }

    public Response read(String string) {
        this.checkPermission(Permission.READ, string);
        ConfigurationItem configurationItem = this.repositoryService.read(string);
        ConfigurationItemDto configurationItemDto = this.dtoWriter.write(configurationItem);
        return ResponseFactory.status((Response.Status)Response.Status.OK).entity((Object)configurationItemDto).build();
    }

    public Response move(String string, String string2) {
        this.checkPermission(Permission.EDIT_REPO, string);
        ConfigurationItem configurationItem = this.repositoryService.read(string);
        this.repositoryService.move(configurationItem, string2);
        return this.read(string2);
    }

    public Response rename(@PathParam(value="id") String string, @QueryParam(value="newName") String string2) {
        this.checkPermission(Permission.EDIT_REPO, string);
        this.repositoryService.rename(string, string2);
        ConfigurationItem configurationItem = this.repositoryService.read(string.substring(0, string.lastIndexOf(47) + 1) + string2);
        return ResponseFactory.ok((Object)this.dtoWriter.write(configurationItem)).build();
    }

    public Response update(String string, ConfigurationItemDto configurationItemDto) {
        this.checkPermission(Permission.EDIT_REPO, string);
        configurationItemDto.setId(string);
        Object t = this.dtoReader.read(configurationItemDto);
        return this.updateInternal((ConfigurationItem)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response update(String string, ArtifactAndData artifactAndData) {
        this.checkPermission(Permission.EDIT_REPO, string);
        artifactAndData.getArtifact().setId(string);
        WorkDir workDir = this.workDirFactory.newWorkDir();
        try {
            ConfigurationItem configurationItem = this.dtoReader.read(artifactAndData, workDir);
            Response response = this.updateInternal(configurationItem);
            return response;
        }
        finally {
            workDir.delete();
        }
    }

    public Response delete(String string) {
        if (Permission.IMPORT_REMOVE.isApplicableTo(string)) {
            this.checkPermission(Permission.IMPORT_REMOVE, string);
        } else {
            this.checkPermission(Permission.EDIT_REPO, string);
        }
        this.repositoryService.delete(new String[]{string});
        return ResponseFactory.noContent().build();
    }

    public Response exists(@PathParam(value="id") String string) {
        boolean bl = this.repositoryService.exists(string);
        if (bl) {
            return ResponseFactory.ok().build();
        }
        return ResponseFactory.status((int)404).build();
    }

    private Response createInternal(ConfigurationItem configurationItem) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(configurationItem);
        if (response != null) {
            return response;
        }
        this.repositoryService.create(new ConfigurationItem[]{configurationItem});
        return this.reloadEntityAndCreateSuccessResponse(configurationItem);
    }

    private Response validateEntityAndCreateErrorResponseIfNeeded(ConfigurationItem configurationItem) {
        List list = this.validator.validate(configurationItem, (List)Lists.newArrayList());
        if (!list.isEmpty()) {
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.dtoWriter.write(configurationItem, list)).build();
        }
        return null;
    }

    private Response validateEntityAndCreateErrorResponseIfNeeded(Collection<ConfigurationItem> collection) {
        ConfigurationItemDtos configurationItemDtos = new ConfigurationItemDtos();
        boolean bl = true;
        ConfigurationItem[] configurationItemArray = collection.toArray(new ConfigurationItem[collection.size()]);
        for (ConfigurationItem configurationItem : collection) {
            List list = this.validator.validate(configurationItem, configurationItemArray);
            configurationItemDtos.add(this.dtoWriter.write(configurationItem, list));
            bl = bl && list.isEmpty();
        }
        if (!bl) {
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)configurationItemDtos).build();
        }
        return null;
    }

    private Response reloadEntityAndCreateSuccessResponse(ConfigurationItem configurationItem) {
        ConfigurationItem configurationItem2 = this.repositoryService.read(configurationItem.getId());
        return ResponseFactory.created((Object)this.dtoWriter.write(configurationItem2)).build();
    }

    private Response createInternal(Collection<ConfigurationItem> collection) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(collection);
        if (response != null) {
            return response;
        }
        ConfigurationItem[] configurationItemArray = collection.toArray(new ConfigurationItem[collection.size()]);
        this.repositoryService.create(configurationItemArray);
        return this.reloadEntityAndCreateSuccessResponse(collection);
    }

    private Response reloadEntityAndCreateSuccessResponse(Collection<ConfigurationItem> collection) {
        ArrayList arrayList = Lists.newArrayList();
        for (ConfigurationItem configurationItem : collection) {
            ConfigurationItem configurationItem2 = this.repositoryService.read(configurationItem.getId());
            arrayList.add(configurationItem2);
        }
        return ResponseFactory.created((Object)this.dtoWriter.write(arrayList)).build();
    }

    private Response updateInternal(ConfigurationItem configurationItem) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(configurationItem);
        if (response != null) {
            return response;
        }
        this.repositoryService.update(new ConfigurationItem[]{configurationItem});
        return this.reloadEntityAndCreateSuccessResponse(configurationItem);
    }
}

