package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.task.TaskArchive;

public enum WidgetRegistry {

	DEPLOYMENTSUCCESS("deploymentSuccess") {
		@Override
		public final Widget getWidget(final TaskArchive taskArchive) {
			return DeploymentsPercentageWidgetData.getInstance(taskArchive);
		}
	},
	DEPLOYMENTDURATION("deploymentDuration") {
		@Override
		public final Widget getWidget(final TaskArchive taskArchive) {
			return DeploymentsDurationFrequencyWidget.getInstance(taskArchive);
		}
	},
	DEPLOYMENTTREND("deploymentTrend") {
		@Override
		public Widget getWidget(final TaskArchive taskArchive) {
			return DeploymentTrendsWidget.getInstance(taskArchive);
		}
	},
	DEPLOYMENTTRENDPERCENTILE("deploymentTrendPercentile") {
		@Override
		public Widget getWidget(final TaskArchive taskArchive) {
			return DeploymentTrendsPercentileWidget.getInstance(taskArchive);
		}
	},
	TOP5SUCCESSFULDEPLOYMENTS("top5SuccessfulDeployments") {
		@Override
		public Widget getWidget(final TaskArchive taskArchive) {
			return Top5SuccessfulDeployments.getInstance(taskArchive);
		}
	},
	TOP5RETRIEDDEPLOYMENTS("top5RetriedDeployments") {
		@Override
		public Widget getWidget(final TaskArchive taskArchive) {
			return Top5RetriedDeployments.getInstance(taskArchive);
		}
	},
	TOP5LONGESTRUNNINGDEPLOYMENTS("top5LongestRunningDeployments") {
		@Override
		public Widget getWidget(final TaskArchive taskArchive) {
			return Top5LongestRunningDeployments.getInstance(taskArchive);
		}
	};

	private String widgetName;

	private WidgetRegistry(final String widgetName) {
		this.widgetName = widgetName;
	}

	public final String getWidgetType() {
		return widgetName;
	}

	public abstract Widget getWidget(final TaskArchive taskArchive);
}
