package com.xebialabs.deployit.core.rest.api.reports.widgets;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.Report.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive.TaskCallback;

public class DeploymentsPercentageWidgetData extends DashboardWidgetBase {

	private DeploymentsPercentageWidgetData(final TaskArchive taskArchive) {
		this.taskArchive = taskArchive;
	}

	public final static Widget getInstance(final TaskArchive taskArchive){
		return new DeploymentsPercentageWidgetData(taskArchive);
	};
	
	@Override
	public Report getReport(final Date beginDate, final Date endDate) {
		return generateReportData(groupCompletedTasksByState(new ArchivedTaskSearchParameters().createdBetween(beginDate.getCalendar(), endDate.getCalendar())));
	}
	
	private Report generateReportData(TaskStateData stateData) {
		final Report report = new Report();
		if (stateData.getTotalTasks() == 0)
			return report;
		ReportLine line = report.addLine();
		DecimalFormat format = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
		line.addValue("noOfSuccessfulDeployments",
		        format.format(getPercentage(stateData.getNoOfSuccessfulDeployments().get(), stateData.getTotalTasks())));
		line.addValue("noOfAbortedDeployments",
		        format.format(getPercentage(stateData.getNoOfAbortedDeployments().get(), stateData.getTotalTasks())));
		line.addValue("noOfFailedDeployments",
		        format.format(getPercentage(stateData.getNoOfFailedDeployments().get(), stateData.getTotalTasks())));
		return report;
	}

	/**
	 * Groups only completed tasks by state. Ignores the middle states like EXECUTING or PENDING.
	 * 
	 * @param foundTasks
	 * @return
	 */
	private TaskStateData groupCompletedTasksByState(ArchivedTaskSearchParameters archivedTaskSearchParameters) {
		final TaskStateData stateData = new TaskStateData();
		taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new TaskCallback() {
			public void doWithTask(DeploymentTaskInfo task) {
				switch (task.getState()) {
				case DONE:
					if (task.getFailureCount() == 0) {
						stateData.getNoOfSuccessfulDeployments().incrementAndGet();
					} else
						stateData.getNoOfFailedDeployments().incrementAndGet();
					break;
				case CANCELLED:
					stateData.getNoOfAbortedDeployments().incrementAndGet();
					break;
				}
			}
		});
		return stateData;
	}

	
}
