package com.xebialabs.deployit.core.rest.api.reports;

import java.util.Map;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive.TaskCallback;

public class DeploymentsKeyIndicator {

	private TaskArchive taskArchive;

	public DeploymentsKeyIndicator(TaskArchive taskArchive) {
		this.taskArchive = taskArchive;
	}

	@SuppressWarnings("deprecation")
    public Report report(final Date startDate, final Date endDate) {
		final Map<String, TaskStateData> tasksMap = new MapMaker().makeComputingMap(new Function<String, TaskStateData>() {
			public TaskStateData apply(String input) {
				return new TaskStateData();
			}
		});

		ArchivedTaskSearchParameters searchTasks = new ArchivedTaskSearchParameters().createdBetween(startDate.getCalendar(), endDate.getCalendar());

		taskArchive.searchTasksWithoutLoadingSteps(searchTasks, new TaskCallback() {
			public void doWithTask(DeploymentTaskInfo task) {
				fillMapWithTask(tasksMap, task);
			}
		});

		return generateReportDataFromTaskMap(tasksMap);
	}

	private Report generateReportDataFromTaskMap(Map<String, TaskStateData> tasksMap) {
		final Report report = new Report();
		for (Map.Entry<String, TaskStateData> entry : tasksMap.entrySet()) {
			final Report.ReportLine reportLine = report.addLine();
			reportLine.addValue("application", entry.getKey().substring(0, entry.getKey().indexOf("~")));
			reportLine.addValue("environment", entry.getKey().substring(entry.getKey().indexOf("~") + 1, entry.getKey().length()));
			reportLine.addValue("noOfSuccessfulDeployments", entry.getValue().getNoOfSuccessfulDeployments().toString());
			reportLine.addValue("noOfFailedDeployments", entry.getValue().getNoOfFailedDeployments().toString());
			reportLine.addValue("noOfAbortedDeployments", entry.getValue().getNoOfAbortedDeployments().toString());
			String averageDeploymentTime = "00:00:00";

			if (entry.getValue().getTotalSuccessfulTasks() > 0) {
				averageDeploymentTime = ReportUtils.formatToHoursMinsSecs(entry.getValue().getAverageDeploymentTime() / entry.getValue().getTotalSuccessfulTasks());
			}
			reportLine.addValue("averageDuration", averageDeploymentTime);
		}
		return report;
	}

	private void fillMapWithTask(Map<String, TaskStateData> tasksMap, DeploymentTaskInfo task) {
		String entityId = task.getApplicationName() + "~" + task.getEnvironment();
		TaskStateData taskStateData = tasksMap.get(entityId);
		taskStateData.addTaskAndDuration(task);
	}
}
