package com.xebialabs.deployit.core.rest.api.reports;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.Report.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTask.DeploymentType;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;

public class DeploymentsForEnvironmentReport {

	private TaskArchive taskArchive;

	public DeploymentsForEnvironmentReport(final TaskArchive taskArchive) {
		this.taskArchive = taskArchive;
	}

	@SuppressWarnings("unchecked")
	public Report report(final String environment, final Date date) {
		ArchivedTaskSearchParameters searchTasks = new ArchivedTaskSearchParameters();
		searchTasks.toEnvironment(environment).createdOnOrBefore(date.getCalendar());

		final Report report = new Report();

		Collection<Map<String, Object>> searchResult = taskArchive.searchTasksWithoutLoadingSteps(searchTasks,
		        new GroupBy(Lists.<String> newArrayList("applicationName"), new Function<Map<String, String>>() {
			        @Override
			        public Map<String, String> invoke(Object previousValue, DeploymentTaskInfo task) {
				        if (previousValue == null) {
					        return getTaskInfo(task);
				        } else {
					        Map<String, String> taskInfo = (Map<String, String>) previousValue;
					        Date completionDate = new Date(taskInfo.get("date"));
					        if (completionDate.compareTo(new Date(task.getCompletionDate(), Date.FORMAT)) < 0) {
						        taskInfo = getTaskInfo(task);
					        }
					        return taskInfo;
				        }
			        }

			        private Map<String, String> getTaskInfo(DeploymentTaskInfo task) {
				        Map<String, String> value = newHashMap();
				        value.put("deploymentType", task.getDeploymentType().name());
				        value.put("user", task.getOwner());
				        value.put("date", new Date(task.getCompletionDate(), Date.FORMAT).toString());
				        value.put("applicationVersion", task.getApplicationVersion());
				        return value;
			        }

			        @Override
			        public String getName() {
				        return "taskInfo";
			        }

		        }));
		List<Map<String, Object>> searchResultList = newArrayList(searchResult);
		Collections.sort(searchResultList, new Comparator<Map<String, Object>>() {
			@Override
			public int compare(Map<String, Object> lhs, Map<String, Object> rhs) {
				Map<String, String> lhsTaskInfo = (Map<String, String>) lhs.get("taskInfo");
				Map<String, String> rhsTaskInfo = (Map<String, String>) rhs.get("taskInfo");
				Date lhsCompletionDate = new Date(lhsTaskInfo.get("date"));
				Date rhsCompletionDate = new Date(rhsTaskInfo.get("date"));
				return lhsCompletionDate.compareTo(rhsCompletionDate);
			}
		});

		// TODO : Sort me by date
		for (Map<String, Object> task : searchResultList) {
			Map<String, String> taskInfo = (Map<String, String>) task.get("taskInfo");
			if (!DeploymentType.valueOf(taskInfo.get("deploymentType")).equals(DeploymentType.UNDEPLOY)) {
				ReportLine line = report.addLine();
				line.addValue("application", task.get("applicationName"));
				line.addValue("version", taskInfo.get("applicationVersion"));
				line.addValue("user", taskInfo.get("user"));
				line.addValue("date", taskInfo.get("date"));
			}
		}
		return report;
	}
}
