/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.Task;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskStateData {
    private AtomicInteger noOfSuccessfulDeployments = new AtomicInteger(0);
    private AtomicInteger noOfFailedDeployments = new AtomicInteger(0);
    private AtomicInteger noOfAbortedDeployments = new AtomicInteger(0);
    private Long averageDeploymentTime = 0L;

    public AtomicInteger getNoOfSuccessfulDeployments() {
        return this.noOfSuccessfulDeployments;
    }

    public void setNoOfSuccessfulDeployments(AtomicInteger atomicInteger) {
        this.noOfSuccessfulDeployments = atomicInteger;
    }

    public AtomicInteger getNoOfFailedDeployments() {
        return this.noOfFailedDeployments;
    }

    public void setNoOfFailedDeployments(AtomicInteger atomicInteger) {
        this.noOfFailedDeployments = atomicInteger;
    }

    public AtomicInteger getNoOfAbortedDeployments() {
        return this.noOfAbortedDeployments;
    }

    public void setNoOfAbortedDeployments(AtomicInteger atomicInteger) {
        this.noOfAbortedDeployments = atomicInteger;
    }

    public Long getAverageDeploymentTime() {
        return this.averageDeploymentTime;
    }

    public void setAverageDeploymentTime(Long l) {
        this.averageDeploymentTime = l;
    }

    public int getTotalSuccessfulTasks() {
        return this.noOfFailedDeployments.get() + this.noOfSuccessfulDeployments.get();
    }

    public int getTotalTasks() {
        return this.noOfAbortedDeployments.get() + this.noOfFailedDeployments.get() + this.noOfSuccessfulDeployments.get();
    }

    public void addTask(DeploymentTaskInfo deploymentTaskInfo) {
        if (deploymentTaskInfo.getState().equals((Object)Task.State.DONE)) {
            if (deploymentTaskInfo.getFailureCount() > 0) {
                this.noOfFailedDeployments.incrementAndGet();
            } else {
                this.noOfSuccessfulDeployments.incrementAndGet();
            }
        } else if (deploymentTaskInfo.getState().equals((Object)Task.State.CANCELLED)) {
            this.noOfAbortedDeployments.incrementAndGet();
        }
    }

    public void addTaskAndDuration(DeploymentTaskInfo deploymentTaskInfo) {
        this.addTask(deploymentTaskInfo);
        if (deploymentTaskInfo.getState().equals((Object)Task.State.DONE)) {
            this.averageDeploymentTime = this.averageDeploymentTime + deploymentTaskInfo.getDurationInMillis();
        }
    }
}

