/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentsStateBreakdownPerEnvironmentReport {
    private TaskArchive taskArchive;

    public DeploymentsStateBreakdownPerEnvironmentReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(List<String> list, Date date, Date date2) {
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters();
        archivedTaskSearchParameters.createdBetween(date.getCalendar(), date2.getCalendar());
        final HashMap hashMap = Maps.newHashMap();
        for (String string : list) {
            archivedTaskSearchParameters.toEnvironment(string);
            this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new JcrTaskArchive.TaskCallback(){

                public void doWithTask(DeploymentTaskInfo deploymentTaskInfo) {
                    DeploymentsStateBreakdownPerEnvironmentReport.this.createTasksMap(hashMap, deploymentTaskInfo);
                }
            });
        }
        for (String string : list) {
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, new TaskStateData());
        }
        return this.generateReportDataFromTaskMap(hashMap);
    }

    private Report generateReportDataFromTaskMap(Map<String, TaskStateData> map) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : map.entrySet()) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("environmentName", (Object)entry.getKey());
            reportLine.addValue("noOfSuccessfulDeployments", (Object)entry.getValue().getNoOfSuccessfulDeployments().toString());
            reportLine.addValue("noOfFailedDeployments", (Object)entry.getValue().getNoOfFailedDeployments().toString());
        }
        return report;
    }

    private void createTasksMap(Map<String, TaskStateData> map, DeploymentTaskInfo deploymentTaskInfo) {
        String string = deploymentTaskInfo.getEnvironment();
        if (deploymentTaskInfo.getState().equals((Object)Task.State.DONE)) {
            if (!map.containsKey(string)) {
                TaskStateData taskStateData = new TaskStateData();
                taskStateData.getNoOfSuccessfulDeployments().incrementAndGet();
                map.put(string, taskStateData);
            } else {
                map.get(string).getNoOfSuccessfulDeployments().incrementAndGet();
            }
        } else if (deploymentTaskInfo.getState().equals((Object)Task.State.CANCELLED)) {
            if (!map.containsKey(string)) {
                TaskStateData taskStateData = new TaskStateData();
                taskStateData.getNoOfAbortedDeployments().incrementAndGet();
                map.put(string, taskStateData);
            } else {
                map.get(string).getNoOfFailedDeployments().incrementAndGet();
            }
        }
    }
}

