package com.xebialabs.deployit.core.rest.api;

import java.io.IOException;
import java.util.Properties;

import javax.ws.rs.core.Response;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.core.api.ServerProxy;
import com.xebialabs.deployit.core.api.dto.ServerInfo;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;

@Controller
public class ServerResource extends AbstractSecuredResource implements ServerProxy {

    @Autowired
    private GarbageCollectionService garbageCollectionService;

	@Override
	public Response shutdown() {
		checkPermission(Permission.ADMIN);
		
		EventBus.publish(new ShutdownEvent());
		return ResponseFactory.noContent().build();
	}

	@Override
	public Response getInfo() {
		ClassPathResource resource = new ClassPathResource("com/xebialabs/deployit/release.properties");
		Properties release = new Properties();
		try {
			release.load(resource.getInputStream());
			ServerInfo si = new ServerInfo();
			si.setVersion(release.getProperty("version"));
			return ResponseFactory.ok(si).build();
		} catch (IOException e) {
			throw new DeployitException(e);
		}
	}

	@Override
	public Response gc() {
		garbageCollectionService.runGarbageCollector();
		return ResponseFactory.noContent().build();
	}
	
}
