/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.james.mime4j.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryFiles {
    private static final ThreadLocal<Set<TempFileStorage>> tempFiles = new ThreadLocal<Set<TempFileStorage>>(){

        @Override
        protected Set<TempFileStorage> initialValue() {
            return Sets.newHashSet();
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(TemporaryFiles.class);

    public static void clear() {
        for (TempFileStorage tempFileStorage : Sets.newHashSet((Iterable)tempFiles.get())) {
            if (!tempFileStorage.deleteWithResponse()) continue;
            tempFiles.get().remove(tempFileStorage);
        }
    }

    public static final class TempFileStorage
    implements Storage {
        private File file;
        private Set<InputStream> streamsOpened = Sets.newHashSet();

        public TempFileStorage(File file) {
            this.file = file;
            ((Set)tempFiles.get()).add(this);
            logger.debug("Registered temporary file: {}", (Object)file);
        }

        public void delete() {
            if (this.file == null) {
                return;
            }
            logger.debug("Deleting temporary file: {}", (Object)this.file);
            for (InputStream inputStream : this.streamsOpened) {
                Closeables.closeQuietly((Closeable)inputStream);
            }
            this.streamsOpened.clear();
            if (this.file != null && this.file.delete()) {
                this.file = null;
            }
        }

        private boolean deleteWithResponse() {
            this.delete();
            return this.file == null;
        }

        public InputStream getInputStream() throws IOException {
            if (this.file == null) {
                throw new IllegalStateException("storage has been deleted");
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
            this.streamsOpened.add(bufferedInputStream);
            return bufferedInputStream;
        }
    }
}

