/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DeploymentsPercentageWidgetData
extends DashboardWidgetBase {
    private DeploymentsPercentageWidgetData(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public static final Widget getInstance(TaskArchive taskArchive) {
        return new DeploymentsPercentageWidgetData(taskArchive);
    }

    @Override
    public Report getReport(Date beginDate, Date endDate) {
        return this.generateReportData(this.groupCompletedTasksByState(new ArchivedTaskSearchParameters().createdBetween(beginDate.getCalendar(), endDate.getCalendar())));
    }

    private Report generateReportData(TaskStateData stateData) {
        Report report = new Report();
        if (stateData.getTotalTasks() == 0) {
            return report;
        }
        Report.ReportLine line = report.addLine();
        DecimalFormat format = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        line.addValue("noOfSuccessfulDeployments", (Object)format.format(this.getPercentage(stateData.getNoOfSuccessfulDeployments().get(), stateData.getTotalTasks())));
        line.addValue("noOfAbortedDeployments", (Object)format.format(this.getPercentage(stateData.getNoOfAbortedDeployments().get(), stateData.getTotalTasks())));
        line.addValue("noOfFailedDeployments", (Object)format.format(this.getPercentage(stateData.getNoOfFailedDeployments().get(), stateData.getTotalTasks())));
        return report;
    }

    private TaskStateData groupCompletedTasksByState(ArchivedTaskSearchParameters archivedTaskSearchParameters) {
        final TaskStateData stateData = new TaskStateData();
        this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new JcrTaskArchive.TaskCallback(){

            public void doWithTask(DeploymentTaskInfo task) {
                switch (task.getState()) {
                    case DONE: {
                        if (task.getFailureCount() == 0) {
                            stateData.getNoOfSuccessfulDeployments().incrementAndGet();
                            break;
                        }
                        stateData.getNoOfFailedDeployments().incrementAndGet();
                        break;
                    }
                    case CANCELLED: {
                        stateData.getNoOfAbortedDeployments().incrementAndGet();
                    }
                }
            }
        });
        return stateData;
    }
}

