package com.xebialabs.deployit.core.rest.api.reports;

import static com.xebialabs.deployit.core.api.resteasy.Date.FORMAT;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive.TaskCallback;

public class TasksInDateRangeReport {

	private TaskArchive taskArchive;

	public TasksInDateRangeReport(TaskArchive taskArchive) {
		this.taskArchive = taskArchive;
	}

	public Report report(final Date begin, final Date end) {
		ArchivedTaskSearchParameters searchTasks = new ArchivedTaskSearchParameters();
		searchTasks.createdBetween(begin.getCalendar(), end.getCalendar());
		final Report report = new Report();
		taskArchive.searchTasksWithoutLoadingSteps(searchTasks, new TaskCallback() {
			public void doWithTask(DeploymentTaskInfo task) {
				final Report.ReportLine reportLine = report.addLine();
				reportLine.addValue("user", task.getOwner());
				reportLine.addValue("status", task.getState().name());
				reportLine.addValue("startDate", new Date(task.getStartDate(), FORMAT).toString());
				reportLine.addValue("completionDate", new Date(task.getCompletionDate(), FORMAT).toString());
				reportLine.addValue("package", task.getApplicationName() + "/" + task.getApplicationVersion());
				reportLine.addValue("environment", task.getEnvironment());
				fillDeploymentType(reportLine, task);

			}
		});

		return report;
	}

	private void fillDeploymentType(Report.ReportLine reportLine, DeploymentTaskInfo task) {
		String taskType = "Unknown";
		switch (task.getDeploymentType()) {
		case INITIAL:
			taskType = "Initial";
			break;
		case UPGRADE:
			taskType = "Upgrade";
			break;
		case UNDEPLOY:
			taskType = "Undeployment";
			break;
		}
		reportLine.addValue("type", taskType);
	}
}
