/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.SecurityProxy;
import com.xebialabs.deployit.core.api.dto.PrincipalPermissions;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Controller;

@Controller
public class SecurityResource
implements SecurityProxy {
    public Response grant(String permission, String toUser, RepositoryObjectIds onConfigurationItems) {
        this.getPermission(permission).getPermissionHandler().grant(toUser, onConfigurationItems.getRepositoryEntityIds());
        return ResponseFactory.noContent().build();
    }

    public Response deny(String permission, String toUser, RepositoryObjectIds onConfigurationItems) {
        this.getPermission(permission).getPermissionHandler().deny(toUser, onConfigurationItems.getRepositoryEntityIds());
        return ResponseFactory.noContent().build();
    }

    public Response revoke(String permission, String fromUser, RepositoryObjectIds onConfigurationItems) {
        this.getPermission(permission).getPermissionHandler().revoke(fromUser, onConfigurationItems.getRepositoryEntityIds());
        return ResponseFactory.noContent().build();
    }

    public Response retrievePermissions(String user) {
        return ResponseFactory.ok((Object)new PrincipalPermissions(user, SecurityServiceLocator.getPermissionService().getUserPermissions(user))).build();
    }

    private Permission getPermission(String permissionName) {
        Permission permission = Permission.find((String)permissionName);
        if (permission == null) {
            throw new UnknownPermissionException(permissionName);
        }
        return permission;
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class UnknownPermissionException
    extends DeployitException {
        public UnknownPermissionException(String permission) {
            super("Permission %s does not exist.", new Object[]{permission});
        }
    }
}

