/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.DeploymentProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.Deployment;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoReader;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoWriter;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeployedService;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DeploymentResource
extends AbstractSecuredResource
implements DeploymentProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private DeployedService deployedService;
    @Autowired
    private ConfigurationItemDtoWriter dtoWriter;
    @Autowired
    private ConfigurationItemDtoReader dtoReader;
    @Autowired
    private DtoWriter dtoConverter;
    @Autowired
    private ExecutionEngine engine;
    @Autowired
    private Validator validator;
    @Autowired
    private WorkDirFactory workDirFactory;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);

    public Response prepareInitial(@QueryParam(value="version") String versionId, @QueryParam(value="environment") String environmentId) {
        logger.trace("prepareInitial {}, {}", (Object)versionId, (Object)environmentId);
        this.checkPermission(Permission.DEPLOY_INITIAL, Lists.newArrayList((Object[])new String[]{environmentId}));
        Checks.checkNotNull((Object)versionId, (String)"version");
        Checks.checkNotNull((Object)environmentId, (String)"environment");
        ConfigurationItem version = this.repositoryService.read(versionId);
        ConfigurationItem environment = this.repositoryService.read(environmentId);
        Checks.checkArgument((boolean)(version instanceof Version), (String)"%s is not a Version", (Object[])new Object[]{versionId});
        Checks.checkArgument((boolean)(environment instanceof Environment), (String)"%s is not an Environment", (Object[])new Object[]{environmentId});
        Deployment deployment = this.createDeployment((Version)version, (Environment)environment);
        return ResponseFactory.ok((Object)deployment).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response prepareUpgrade(@QueryParam(value="version") String newVersionId, @QueryParam(value="deployedApplication") String deployedApplicationId) {
        logger.trace("prepareUpgrade {}, {}", (Object)newVersionId, (Object)deployedApplicationId);
        Checks.checkNotNull((Object)newVersionId, (String)"version");
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        WorkDir existingWorkDir = this.workDirFactory.newWorkDir();
        WorkDir newWorkDir = this.workDirFactory.newWorkDir();
        try {
            ConfigurationItem deployedApplication = this.repositoryService.read(deployedApplicationId, existingWorkDir);
            Checks.checkArgument((boolean)(deployedApplication instanceof DeployedApplication), (String)"%s is not a DeployedApplication", (Object[])new Object[]{deployedApplicationId});
            Environment env = ((DeployedApplication)deployedApplication).getEnvironment();
            this.checkPermission(Permission.DEPLOY_UPGRADE, env.getId());
            ConfigurationItem newVersion = this.repositoryService.read(newVersionId, newWorkDir);
            Checks.checkArgument((boolean)(newVersion instanceof Version), (String)"%s is not a Version", (Object[])new Object[]{newVersionId});
            ListMultimap upgradedDeployeds = this.deployedService.generateUpgradedDeployeds((Version)newVersion, (DeployedApplication)deployedApplication);
            Deployment deployment = this.createDeployment((Version)newVersion, env);
            deployment.setUpgrade(true);
            deployment.setDeployeds(this.dtoWriter.write((ListMultimap<Boolean, ConfigurationItem>)upgradedDeployeds));
            Response response = ResponseFactory.ok((Object)deployment).build();
            return response;
        }
        finally {
            existingWorkDir.delete();
            newWorkDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response generateAllDeployeds(Deployment deployment) {
        logger.trace("generateAllDeployeds {}", (Object)deployment);
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(Permission.DEPLOY_INITIAL, deployment.getEnvironment());
        WorkDir workDir = this.workDirFactory.newWorkDir();
        try {
            Version version = (Version)this.repositoryService.read(deployment.getVersion(), workDir);
            Environment environment = (Environment)this.repositoryService.read(deployment.getEnvironment(), workDir);
            ListMultimap initialDeployeds = this.deployedService.generateAllDeployeds(version, environment);
            deployment.addAll(this.dtoWriter.write((ListMultimap<Boolean, ConfigurationItem>)initialDeployeds));
            Response response = ResponseFactory.ok((Object)deployment).build();
            return response;
        }
        finally {
            workDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response generateSelectedDeployeds(@QueryParam(value="deployables") List<String> deployableIds, Deployment deployment) {
        logger.trace("generateSelectedDeployeds {}, {}", deployableIds, (Object)deployment);
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(Permission.DEPLOY_INITIAL, deployment.getEnvironment());
        Checks.checkArgument((deployableIds.size() > 0 ? 1 : 0) != 0, (String)"Should select at least one deployable to generate a deployed", (Object[])new Object[0]);
        WorkDir workDir = this.workDirFactory.newWorkDir();
        try {
            Environment environment = (Environment)this.repositoryService.read(deployment.getEnvironment());
            ArrayList deployableCIs = Lists.newArrayList();
            for (String id : deployableIds) {
                deployableCIs.add(this.repositoryService.read(id));
                Checks.checkArgument((boolean)id.startsWith(deployment.getVersion()), (String)"All sources should be from same package", (Object[])new Object[0]);
            }
            ListMultimap selectedDeployeds = this.deployedService.generateSelectedDeployeds((List)deployableCIs, environment);
            deployment.addAll(this.dtoWriter.write((ListMultimap<Boolean, ConfigurationItem>)selectedDeployeds));
            Response response = ResponseFactory.ok((Object)deployment).build();
            return response;
        }
        finally {
            workDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response generateSingleDeployed(@QueryParam(value="deployable") String deployableId, @QueryParam(value="container") String containerId, @QueryParam(value="deployedtype") String deployedType, Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(Permission.DEPLOY_INITIAL, deployment.getEnvironment());
        Checks.checkNotNull((Object)deployableId, (String)"deployable");
        Checks.checkNotNull((Object)containerId, (String)"container");
        WorkDir workDir = this.workDirFactory.newWorkDir();
        try {
            ConfigurationItem deployable = this.repositoryService.read(deployableId);
            Checks.checkArgument((boolean)(deployable instanceof Deployable), (String)"%s should be a Deployable.", (Object[])new Object[]{deployableId});
            ConfigurationItem container = this.repositoryService.read(containerId);
            Checks.checkArgument((boolean)(container instanceof Container), (String)"%s should be a Container.", (Object[])new Object[]{containerId});
            Environment environment = (Environment)this.repositoryService.read(deployment.getEnvironment());
            ListMultimap deployeds = this.deployedService.generateSelectedDeployed((Deployable)deployable, (Container)container, deployedType, environment);
            deployment.addAll(this.dtoWriter.write((ListMultimap<Boolean, ConfigurationItem>)deployeds));
            Response response = ResponseFactory.ok((Object)deployment).build();
            return response;
        }
        finally {
            workDir.delete();
        }
    }

    public Response validate(Deployment deployment) {
        if (!this.validateDeployedsWithValidator(deployment.getDeployeds())) {
            return ResponseFactory.badRequest((Object)deployment).build();
        }
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response deploy(Deployment deployment) {
        logger.trace("deploy {}", (Object)deployment);
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        Task deploymentTask = this.createDeploymentTask(deployment);
        String taskId = this.engine.register(deploymentTask);
        Steps steps = this.dtoConverter.taskToDto(deploymentTask);
        steps.setTaskId(taskId);
        return ResponseFactory.ok((Object)steps).build();
    }

    public Response undeploy(String deployedApplicationId) {
        WorkDir undeploymentWorkDir = this.workDirFactory.newWorkDir();
        try {
            Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
            ConfigurationItem deployedApplication = this.repositoryService.read(deployedApplicationId, undeploymentWorkDir);
            Checks.checkArgument((boolean)(deployedApplication instanceof DeployedApplication), (String)"%s is not a DeployedApplication", (Object[])new Object[]{deployedApplicationId});
            this.checkPermission(Permission.UNDEPLOY, ((DeployedApplication)deployedApplication).getEnvironment().getId());
            Task task = this.deploymentService.prepareUndeployment((DeployedApplication)deployedApplication, undeploymentWorkDir);
            String taskId = this.engine.register(task);
            Steps steps = this.dtoConverter.taskToDto(task);
            steps.setTaskId(taskId);
            return ResponseFactory.ok((Object)steps).build();
        }
        catch (RuntimeException e) {
            undeploymentWorkDir.delete();
            throw e;
        }
    }

    private Task createDeploymentTask(Deployment deployment) {
        Task deploymentTask;
        block5: {
            WorkDir workDir = this.workDirFactory.newWorkDir();
            deploymentTask = null;
            try {
                Version version = (Version)this.repositoryService.read(deployment.getVersion(), workDir);
                if (!deployment.isUpgrade()) {
                    List<ConfigurationItem> deployedEntities = this.dtoReader.read(deployment.getDeployeds(), workDir);
                    Environment environment = (Environment)this.repositoryService.read(deployment.getEnvironment(), workDir);
                    deploymentTask = this.deploymentService.prepareInitialDeployment(version, environment, this.toDeployeds(deployedEntities), workDir);
                    break block5;
                }
                WorkDir existingDeploymentWorkDir = this.workDirFactory.newWorkDir();
                try {
                    List<ConfigurationItem> deployedEntities = this.dtoReader.read(deployment.getDeployeds(), workDir);
                    DeployedApplication existingDeployedApplication = (DeployedApplication)this.repositoryService.read(deployment.getDeployedApplication().getId(), existingDeploymentWorkDir);
                    deploymentTask = this.deploymentService.prepareUpgradeDeployment(version, existingDeployedApplication, this.toDeployeds(deployedEntities), existingDeploymentWorkDir, workDir);
                }
                catch (RuntimeException e) {
                    existingDeploymentWorkDir.delete();
                    throw e;
                }
            }
            catch (RuntimeException e) {
                workDir.delete();
                throw e;
            }
        }
        return deploymentTask;
    }

    private Collection<Deployed> toDeployeds(Collection<ConfigurationItem> deployedEntities) {
        return Collections2.transform(deployedEntities, (Function)new Function<ConfigurationItem, Deployed>(){

            public Deployed apply(ConfigurationItem input) {
                Checks.checkArgument((boolean)(input instanceof Deployed), (String)"%s should be a Deployed", (Object[])new Object[]{input.getId()});
                return (Deployed)input;
            }
        });
    }

    private boolean validateDeployedsWithValidator(List<ConfigurationItemDto> deployeds) {
        boolean allValid = true;
        List<ConfigurationItem> deployedEntitiesInCtx = this.dtoReader.read(deployeds);
        for (int i = 0; i < deployeds.size(); ++i) {
            ConfigurationItemDto deployed = deployeds.get(i);
            ConfigurationItem deployedEntity = deployedEntitiesInCtx.get(i);
            List messages = this.validator.validate(deployedEntity, deployedEntitiesInCtx);
            if (messages.isEmpty()) continue;
            deployed.setValidations(this.dtoWriter.write(deployedEntity, messages).getValidations());
            allValid = false;
        }
        return allValid;
    }

    private Deployment createDeployment(Version version, Environment env) {
        Deployment deployment = new Deployment();
        DeployedApplication deployedApplication = (DeployedApplication)DescriptorRegistry.getDescriptor((Type)Type.valueOf(DeployedApplication.class)).newInstance();
        deployedApplication.setVersion(version);
        deployedApplication.setEnvironment(env);
        IdGenerator.generateId((DeployedApplication)deployedApplication);
        deployment.setDeployedApplication(this.dtoWriter.write((ConfigurationItem)deployedApplication));
        return deployment;
    }
}

