package com.xebialabs.deployit.core.rest.api.reports.widgets;

import java.util.Map;

import com.xebialabs.deployit.task.Task.State;
import com.xebialabs.deployit.task.TaskArchive;

public class Top5SuccessfulDeployments extends Top5DeploymentsByState {

	private Top5SuccessfulDeployments(final TaskArchive taskArchive) {
		this.taskArchive = taskArchive;
	}

	public final static Widget getInstance(final TaskArchive taskArchive) {
		return new Top5SuccessfulDeployments(taskArchive);
	}

	@Override
	boolean accept(Map<String, Object> line) {
		return State.DONE.equals((State) line.get(STATE)) && (Integer) line.get(FAILURE_COUNT) == 0;
	}
}
