/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DeploymentTrendsPercentileWidget
extends DashboardWidgetBase {
    private static final int EIGHTIETH_PERCENTILE = 80;

    private DeploymentTrendsPercentileWidget(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public static final Widget getInstance(TaskArchive taskArchive) {
        return new DeploymentTrendsPercentileWidget(taskArchive);
    }

    @Override
    public Report getReport(Date begin, Date end) {
        Map<String, List<DeploymentTaskInfo>> groupedTasks = this.groupSuccesfulTasksByMonth(begin, end);
        Map<String, Long> monthPercentileMap = this.calculatePercentiles(groupedTasks);
        return this.generateReportData(monthPercentileMap);
    }

    private Map<String, List<DeploymentTaskInfo>> groupSuccesfulTasksByMonth(Date begin, Date end) {
        ArchivedTaskSearchParameters params = new ArchivedTaskSearchParameters().createdBetween(begin.getCalendar(), end.getCalendar()).thatCompleted();
        final Map<String, List<DeploymentTaskInfo>> groupedTasks = this.initializeMap(begin, end, new Function<String, List<DeploymentTaskInfo>>(){

            public List<DeploymentTaskInfo> apply(String input) {
                return Lists.newArrayList();
            }
        });
        this.taskArchive.searchTasksWithoutLoadingSteps(params, new JcrTaskArchive.TaskCallback(){

            public void doWithTask(DeploymentTaskInfo task) {
                ((List)groupedTasks.get(DeploymentTrendsPercentileWidget.this.monthFormat.format(task.getCompletionDate().getTime()))).add(task);
            }
        });
        return groupedTasks;
    }

    private Map<String, Long> calculatePercentiles(Map<String, List<DeploymentTaskInfo>> groupedTasks) {
        return Maps.transformValues(groupedTasks, (Function)new Function<List<DeploymentTaskInfo>, Long>(){

            public Long apply(List<DeploymentTaskInfo> input) {
                return DeploymentTrendsPercentileWidget.this.getPercentile(input, 80);
            }
        });
    }

    private long getPercentile(List<DeploymentTaskInfo> tasks, int percentileRatio) {
        if (tasks.size() == 0) {
            return 0L;
        }
        Collections.sort(tasks, new Comparator<DeploymentTaskInfo>(){

            @Override
            public int compare(DeploymentTaskInfo o1, DeploymentTaskInfo o2) {
                return (int)(o1.getDurationInMillis() - o2.getDurationInMillis());
            }
        });
        int indexOfPercentile = Long.valueOf(Math.round((double)percentileRatio * (double)tasks.size() / 100.0 + 0.5)).intValue();
        if (indexOfPercentile > 0) {
            --indexOfPercentile;
        }
        DeploymentTaskInfo task = tasks.get(indexOfPercentile);
        return task.getDurationInMillis();
    }

    private Report generateReportData(Map<String, Long> monthPercentileMap) {
        Report report = new Report();
        for (String month : monthPercentileMap.keySet()) {
            Report.ReportLine line = report.addLine();
            line.addValue("month", (Object)month);
            line.addValue("deploymentTime", (Object)this.formatToMins(monthPercentileMap.get(month)));
        }
        return report;
    }
}

