/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.ReportProxy;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.reports.AggregatedDeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsForEnvironmentReport;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsStateBreakdownReport;
import com.xebialabs.deployit.core.rest.api.reports.ReportFilterType;
import com.xebialabs.deployit.core.rest.api.reports.TasksInDateRangeReport;
import com.xebialabs.deployit.core.rest.api.reports.widgets.WidgetRegistry;
import com.xebialabs.deployit.task.TaskArchive;
import java.text.SimpleDateFormat;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ReportResource
implements ReportProxy {
    @Autowired
    private TaskArchive taskArchive;

    public Response deploymentsForEnvironment(String environment, Date date, String acceptedContentType) {
        Checks.checkNotNull((Object)environment, (String)"environment");
        Checks.checkNotNull((Object)date, (String)"date");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"date");
        Report report = new DeploymentsForEnvironmentReport(this.taskArchive).report(environment, date);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        return this.createResponse(report, String.format("deployments-%s-%s.csv", environment.replaceAll("/", "_"), dateFormat.format(date.getCalendar().getTime())), acceptedContentType);
    }

    public Response tasksInDateRange(Date begin, Date end, String acceptedContentType) {
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Report report = new TasksInDateRangeReport(this.taskArchive).report(begin, end);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        return this.createResponse(report, String.format("tasks-%s-%s.csv", dateFormat.format(begin.getCalendar().getTime()), dateFormat.format(end.getCalendar().getTime())), acceptedContentType);
    }

    public Response deploymentsStateBreakdown(String filterType, Date begin, Date end, String acceptedContentType, RepositoryObjectIds repositoryObjectIds) {
        Checks.checkNotNull((Object)filterType, (String)"filterType");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkNotNull((Object)repositoryObjectIds.getRepositoryEntityIds(), (String)"repositoryObjectIds");
        ReportFilterType reportFilterType = ReportFilterType.valueOf(filterType.toUpperCase());
        Report report = new DeploymentsStateBreakdownReport(this.taskArchive).report(repositoryObjectIds.getRepositoryEntityIds(), begin, end, reportFilterType);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        return this.createResponse(report, String.format("deployments-by-state-%s-%s.csv", dateFormat.format(begin.getCalendar().getTime()), dateFormat.format(end.getCalendar().getTime())), acceptedContentType);
    }

    public Response deploymentsKeyIndicator(Date begin, Date end, String acceptedContentType) {
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Report report = new DeploymentsKeyIndicator(this.taskArchive).report(begin, end);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        return this.createResponse(report, String.format("deployments-key-indicator-%s-%s.csv", dateFormat.format(begin.getCalendar().getTime()), dateFormat.format(end.getCalendar().getTime())), acceptedContentType);
    }

    public Response deploymentsKeyIndicatorAggregatedByFilterType(String filterType, Date begin, Date end, String acceptedContentType, RepositoryObjectIds repositoryObjectIds) {
        Checks.checkNotNull((Object)filterType, (String)"filterType");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkNotNull((Object)repositoryObjectIds.getRepositoryEntityIds(), (String)"repositoryObjectIds");
        ReportFilterType reportFilterType = ReportFilterType.valueOf(filterType.toUpperCase());
        Report report = new AggregatedDeploymentsKeyIndicator(this.taskArchive).report(begin, end, reportFilterType, repositoryObjectIds.getRepositoryEntityIds());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        return this.createResponse(report, String.format("aggregated-deployments-key-indicator-%s-%s-%s.csv", filterType, dateFormat.format(begin.getCalendar().getTime()), dateFormat.format(end.getCalendar().getTime())), acceptedContentType);
    }

    public Response getDashboardWidgetReport(String widget, Date begin, Date end) {
        Checks.checkNotNull((Object)widget, (String)"widget");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Preconditions.checkArgument((begin.getCalendar().getTime().compareTo(end.getCalendar().getTime()) <= 0 ? 1 : 0) != 0);
        return ResponseFactory.ok((Object)WidgetRegistry.valueOf(WidgetRegistry.class, widget.toUpperCase()).getWidget(this.taskArchive).getReport(begin, end)).build();
    }

    private Response createResponse(Report report, String reportName, String acceptedContentType) {
        Response.ResponseBuilder responseBuilder = ResponseFactory.ok((Object)report);
        if ("text/csv".equals(acceptedContentType)) {
            responseBuilder.header("Content-Disposition", (Object)("attachment; filename=" + reportName));
        }
        return responseBuilder.build();
    }
}

