/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.ExportProxy;
import com.xebialabs.deployit.core.api.dto.FullTaskInfos;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ExportResource
implements ExportProxy {
    @Autowired
    private TaskArchive taskArchive;
    @Autowired
    private DtoConverter dtoConverter;

    public Response getFullArchivedTasks() {
        return ResponseFactory.ok((Object)this.getFullTaskInfos(new ArchivedTaskSearchParameters())).build();
    }

    public Response getFullArchivedTasksInDateRange(Date beginDate, Date endDate) {
        Checks.checkNotNull((Object)beginDate, (String)"beginDate");
        Checks.checkNotNull((Object)endDate, (String)"endDate");
        ArchivedTaskSearchParameters taskSearchParameters = new ArchivedTaskSearchParameters();
        taskSearchParameters.createdBetween(beginDate.getCalendar(), endDate.getCalendar());
        return ResponseFactory.ok((Object)this.getFullTaskInfos(taskSearchParameters)).build();
    }

    private final FullTaskInfos getFullTaskInfos(ArchivedTaskSearchParameters taskSearchParameters) {
        FullTaskInfos fullTaskInfos = new FullTaskInfos();
        Collection allTasks = this.taskArchive.searchTasks(taskSearchParameters);
        for (DeploymentTaskInfo deploymentTaskInfo : allTasks) {
            fullTaskInfos.addTask(this.dtoConverter.fullArchivedTaskToDto(deploymentTaskInfo));
        }
        return fullTaskInfos;
    }
}

