/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.DescriptorProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.ArrayList;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DescriptorResource
implements DescriptorProxy {
    @Autowired
    private DtoConverter dtoConverter;

    public Response list() {
        ConfigurationItemDescriptorList descriptorList = new ConfigurationItemDescriptorList();
        ArrayList<ConfigurationItemDescriptorDto> descriptors = new ArrayList<ConfigurationItemDescriptorDto>();
        for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
            if (descriptor.isVirtual()) continue;
            ConfigurationItemDescriptorDto descriptorDto = this.dtoConverter.descriptorToDto(descriptor);
            descriptors.add(descriptorDto);
        }
        descriptorList.setDescriptors(descriptors);
        return ResponseFactory.ok((Object)descriptorList).build();
    }

    public Response find(@PathParam(value="type") String type) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)type));
        ConfigurationItemDescriptorDto dto = this.dtoConverter.descriptorToDto(descriptor);
        return ResponseFactory.ok((Object)dto).build();
    }
}

