/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.secured;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.security.AccessControlService;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionService;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSecuredResource {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private AccessControlService accessControlService;

    protected void checkPermission(Permission permission) {
        this.checkPermission(permission, Lists.newArrayList());
    }

    protected void checkPermission(Permission permission, String id) {
        this.checkPermission(permission, Lists.newArrayList((Object[])new String[]{id}));
    }

    protected void checkPermission(Permission permission, List<String> onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, onConfigurationItems);
        }
    }

    protected void checkWriteAccessTo(String id) {
        if (!this.accessControlService.hasPrivilege(id, "jcr:write")) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)id, (String)"Write");
        }
    }
}

