/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.ListMultimap;
import com.xebialabs.deployit.core.api.QueryProxy;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.core.rest.api.SearchParameterFactory;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.service.comparison.Comparator;
import java.util.List;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class QueryResource
implements QueryProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DtoConverter dtoConverter;
    @Autowired
    private Comparator comparator;

    public Response list(@QueryParam(value="typeName") String typeName, @QueryParam(value="archetype") boolean archetype, @QueryParam(value="page") long page, @QueryParam(value="resultsPerPage") long resultPerPage, @QueryParam(value="property") List<PropertyValue> values, String parent, String id) {
        SearchParameters searchParam = SearchParameterFactory.createSearchParam(typeName, archetype, page, resultPerPage, values, parent, id);
        RepositoryObjectIds dto = new RepositoryObjectIds();
        dto.setRepositoryEntityIds(this.repositoryService.list(searchParam));
        return ResponseFactory.ok((Object)dto).build();
    }

    public Response readMultiple(RepositoryObjectIds repositoryObjectIds) {
        RepositoryObjects result = new RepositoryObjects();
        for (String repositoryObjectId : repositoryObjectIds.getRepositoryEntityIds()) {
            RepositoryObjectEntity entity = this.repositoryService.read(repositoryObjectId);
            result.add(this.dtoConverter.toDto(entity));
        }
        return ResponseFactory.ok((Object)result).build();
    }

    public Response compare(String reference, List<String> ids) {
        RepositoryObjectEntity referenceEntity = this.repositoryService.read(reference);
        RepositoryObjectEntity[] entities = new RepositoryObjectEntity[ids.size()];
        int index = 0;
        for (String id : ids) {
            entities[index] = this.repositoryService.read(id);
            ++index;
        }
        ListMultimap multimap = this.comparator.compare(referenceEntity, entities);
        return ResponseFactory.ok((Object)Comparison.from((ListMultimap)multimap)).build();
    }
}

