package com.xebialabs.deployit.core.rest.api.reports;

import static com.google.common.collect.Lists.newArrayList;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.SearchParameterFactory;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskRegistry;

public class DeploymentsBreakdownInDateRangeReport {
	
	private RepositoryService repositoryService;
    private TaskRegistry taskRegistry;
    
	public DeploymentsBreakdownInDateRangeReport(RepositoryService repositoryService, TaskRegistry taskRegistry) {
		this.repositoryService = repositoryService;
		this.taskRegistry = taskRegistry;
	}
    
	public Report report(final List<String> applicationIds, final Date begin, final Date end) {
        Report report = new Report();
        Map<String, AtomicInteger> deploymentsBreakdownMap = Maps.newHashMap(); 
        List<PropertyValue> values = newArrayList();
        final SearchParameters searchParams = SearchParameterFactory.createSearchParam(Deployment.class.getName(), false, 0, -1, values, "", "");
        
        final List<ConfigurationItemEntity> deployments = repositoryService.listEntities(searchParams);
        
        for (ConfigurationItemEntity deployment : deployments) {
            if (deployment.getCreatingTaskId() != null) {
                Task task = taskRegistry.getTask(deployment.getCreatingTaskId());
                if (task.getStartDate().after(begin.getCalendar()) && task.getCompletionDate().before(end.getCalendar())) {
                    ConfigurationItemEntity deploymentPackage = repositoryService.read((String) deployment.getValue("source"));
                    String fullApplicationId = deploymentPackage.getValue("application").toString();
                    String applicationId = fullApplicationId.substring(fullApplicationId.indexOf("/") + 1);
                    if(applicationIds.contains(applicationId)) {
                    	if(deploymentsBreakdownMap.containsKey(applicationId)) {
                    		deploymentsBreakdownMap.get(applicationId).incrementAndGet();
                    	}else{
                    		deploymentsBreakdownMap.put(applicationId, new AtomicInteger(1));
                    	}
                    }
                }
            }
        }
        for (Iterator<String> iterator = applicationIds.iterator(); iterator.hasNext();) {
			String applicationId  = (String) iterator.next();
			if(!deploymentsBreakdownMap.containsKey(applicationId)){
				deploymentsBreakdownMap.put(applicationId, new AtomicInteger(0));
			}
		}
        if(!deploymentsBreakdownMap.isEmpty()){
        	report = generateReportFromMap(deploymentsBreakdownMap);
        }
        return report;
    }

	private Report generateReportFromMap(Map<String, AtomicInteger> deploymentsBreakdownMap) {
		final Report report = new Report();
		for (Map.Entry<String, AtomicInteger> entry : deploymentsBreakdownMap.entrySet()) {
			final Report.ReportLine reportLine = report.addLine();
	    	reportLine.addValue("application", entry.getKey());
	    	reportLine.addValue("noofdeployments", entry.getValue().toString());
		}
		return report;
	}
    

}
