package com.xebialabs.deployit.core.rest.api;

import static org.apache.commons.lang.StringUtils.isNotBlank;

import java.util.List;

import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.repository.SearchParameters;

public class SearchParameterFactory {
    static final long DEFAULT_RESULTS_PER_PAGE = 25L;

	public static SearchParameters createSearchParam(String typeName, boolean archetype, long page, long resultPerPage, final List<PropertyValue> values,
	        final com.xebialabs.deployit.core.api.resteasy.Date at) {
		SearchParameters searchParameters = createSearchParam(typeName, archetype, page, resultPerPage, values);
		if (at != null) {
			searchParameters.setAt(at.getCalendar());
		}
		return searchParameters;
	}

	public static SearchParameters createSearchParam(String typeName, boolean archetype, long page, long resultPerPage, final List<PropertyValue> values) {
		SearchParameters searchParam = new SearchParameters();

		if (isNotBlank(typeName)) {
			searchParam.setConfigurationItemType(typeName);
		}

		if (archetype) {
			searchParam.setArchetypes();
		} else {
			searchParam.setConfigurationItems();
		}

		// If not given, are default to 0.
		searchParam.setPage(page);
		// If different from 0 then set it; 0 means default, negative will mean 'all'.
		if (resultPerPage > 0) {
			searchParam.setResultsPerPage(resultPerPage);
		} else if (resultPerPage == 0) {
            searchParam.setResultsPerPage(DEFAULT_RESULTS_PER_PAGE);
        }

		for (PropertyValue value : values) {
			searchParam.addProperty(value.getKey(), value.getValue());
		}

		return searchParam;
	}

	public static SearchParameters createSearchParam(String typeName, boolean archetype, long page, long resultPerPage, final List<PropertyValue> values,
	        final String parent, final String id) {
		SearchParameters searchParam = createSearchParam(typeName, archetype, page, resultPerPage, values);
		if (isNotBlank(parent)) {
			searchParam.setParent(parent);
		}
		if (isNotBlank(id)) {
			searchParam.setId(id);
		}
		return searchParam;
	}
}
