package com.xebialabs.deployit.core.rest.api;

import static com.xebialabs.deployit.checks.Checks.checkNotNull;

import javax.ws.rs.core.Response;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.core.api.ReportProxy;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsBreakdownInDateRangeReport;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsForEnvironmentReport;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsStateBreakdownReport;
import com.xebialabs.deployit.core.rest.api.reports.TasksInDateRangeReport;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.task.TaskRegistry;

@Controller
public class ReportResource implements ReportProxy {
	@Autowired
	private RepositoryService repositoryService;

	@Autowired
	private TaskRegistry taskRegistry;

	@Override
	public Response deploymentsForEnvironment(final String environment, final Date date) {
		checkNotNull(environment, "environment");
		checkNotNull(date, "date");
		checkNotNull(date.getCalendar(), "date");

		Report report = new DeploymentsForEnvironmentReport(repositoryService, taskRegistry).report(environment, date);

		return ResponseFactory.ok(report).build();
	}

	@Override
	public Response tasksInDateRange(final Date begin, final Date end) {
		checkNotNull(begin, "begin");
		checkNotNull(begin.getCalendar(), "begin");
		checkNotNull(end, "end");
		checkNotNull(end.getCalendar(), "end");

		Report report = new TasksInDateRangeReport(taskRegistry).report(begin, end);

		return ResponseFactory.ok(report).build();
	}

	@Override
	public Response deploymentsBreakdownInDateRange(Date begin, Date end, RepositoryObjectIds repositoryObjectIds) {
		checkNotNull(repositoryObjectIds.getRepositoryEntityIds(), "repositoryObjectIds");
		checkNotNull(begin, "begin");
		checkNotNull(begin.getCalendar(), "begin");
		checkNotNull(end, "end");
		checkNotNull(end.getCalendar(), "end");

		Report report = new DeploymentsBreakdownInDateRangeReport(repositoryService, taskRegistry).report(
				repositoryObjectIds.getRepositoryEntityIds(), begin, end);

		return ResponseFactory.ok(report).build();
	}

	@Override
	public Response deploymentsStateBreakdown(String filterType, Date begin, Date end,
			RepositoryObjectIds repositoryObjectIds) {
		checkNotNull(filterType, "filterType");
		checkNotNull(begin, "begin");
		checkNotNull(begin.getCalendar(), "begin");
		checkNotNull(end, "end");
		checkNotNull(end.getCalendar(), "end");
		checkNotNull(repositoryObjectIds.getRepositoryEntityIds(), "repositoryObjectIds");
		Report report = new DeploymentsStateBreakdownReport(taskRegistry.getTaskArchive()).report(repositoryObjectIds
				.getRepositoryEntityIds(), begin, end, filterType);
		return ResponseFactory.ok(report).build();
	}
}
