package com.xebialabs.deployit.core.rest.api;

import static com.xebialabs.deployit.core.rest.api.SearchParameterFactory.createSearchParam;

import java.util.List;

import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.google.common.collect.ListMultimap;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.QueryProxy;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.service.comparison.Comparator;

/**
 */
@Controller
public class QueryResource implements QueryProxy {

	@Autowired
	private RepositoryService repositoryService;

	@Autowired
	private DtoConverter dtoConverter;

    @Autowired
    private Comparator comparator;

    @Override
	public Response list(@QueryParam("typeName") final String typeName, @QueryParam("archetype") final boolean archetype, @QueryParam("page") final long page,
	        @QueryParam("resultsPerPage") final long resultPerPage, @QueryParam("property") final List<PropertyValue> values, final String parent, final String id) {
		SearchParameters searchParam = createSearchParam(typeName, archetype, page, resultPerPage, values, parent, id);
		RepositoryObjectIds dto = new RepositoryObjectIds();
		dto.setRepositoryEntityIds(repositoryService.list(searchParam));
		return ResponseFactory.ok(dto).build();
	}

	@Override
	public Response readMultiple(RepositoryObjectIds repositoryObjectIds) {
		final RepositoryObjects result = new RepositoryObjects();
		for (String repositoryObjectId : repositoryObjectIds.getRepositoryEntityIds()) {
			final RepositoryObjectEntity entity = repositoryService.read(repositoryObjectId);
			result.add(dtoConverter.toDto(entity));
		}
		return ResponseFactory.ok(result).build();
	}

    @Override
    public Response compare(final String reference, final List<String> ids) {
        RepositoryObjectEntity referenceEntity = repositoryService.read(reference);
        RepositoryObjectEntity[] entities = new RepositoryObjectEntity[ids.size()];
        int index = 0;
        for (String id : ids) {
            entities[index] = repositoryService.read(id);
            index++;
        }

        final ListMultimap<String,String> multimap = comparator.compare(referenceEntity, entities);

        return ResponseFactory.ok(Comparison.from(multimap)).build();
    }

}
