package com.xebialabs.deployit.core.rest.api;

import java.util.List;

import javax.ws.rs.core.Response;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.core.api.DiscoveryProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItem;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.discovery.DiscoveryService;

/**
 */
@Controller
public class DiscoveryResource extends AbstractSecuredResource implements DiscoveryProxy {
	@Autowired
	private RepositoryService repositoryService;

	@Autowired
	private DtoConverter dtoConverter;

	@Autowired
	private DiscoveryService discoveryService;

	@Override
	public Response discover(ConfigurationItem dto) {
		checkPermission(Permission.DISCOVERY);
        ConfigurationItemEntity middleware = (ConfigurationItemEntity) dtoConverter.fromDto(dto);
        List<ConfigurationItemEntity> discovered = discoveryService.fetchConfigurationWithChildren(middleware);
		return ResponseFactory.ok(dtoConverter.toDto(discovered)).build();
	}

	@Override
	public Response realityCheck(final String id) {
		checkPermission(Permission.DISCOVERY);
		ConfigurationItemEntity middlewareEntity = repositoryService.read(id);
		middlewareEntity = discoveryService.fetchConfiguration(middlewareEntity);
		return ResponseFactory.ok(dtoConverter.toDto(middlewareEntity)).build();

	}

}
