/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.service.status;

import ai.digital.deploy.webhook.WebhookServer;
import com.xebialabs.deployit.core.events.dto.ApplicationDeploymentPackageState;
import com.xebialabs.deployit.core.events.dto.DeployedApplicationPackage;
import com.xebialabs.deployit.core.service.ApplicationAndEnvironmentFilter;
import com.xebialabs.deployit.core.service.status.DeploymentPackageStatusService;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.service.dependency.RepositoryServiceAware;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\u0007\u000e\u0001iA\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005u!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0003\\\u0001\u0011\u0005A\fC\u0004f\u0001\t\u0007IQ\u00014\t\r)\u0004\u0001\u0015!\u0004h\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015Y\u0007\u0001\"\u0011{\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002n\u0001!I!a\u001c\u0003I]+'\r[8pW\u0012+\u0007\u000f\\8z[\u0016tG\u000fU1dW\u0006<Wm\u0015;biV\u001c8\t\\5f]RT!AD\b\u0002\rM$\u0018\r^;t\u0015\t\u0001\u0012#A\u0004tKJ4\u0018nY3\u000b\u0005I\u0019\u0012\u0001B2pe\u0016T!\u0001F\u000b\u0002\u0011\u0011,\u0007\u000f\\8zSRT!AF\f\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\r\u0001Y\u0012%\n\u00171!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!eI\u0007\u0002\u001b%\u0011A%\u0004\u0002\u001f\t\u0016\u0004Hn\\=nK:$\b+Y2lC\u001e,7\u000b^1ukN\u001cVM\u001d<jG\u0016\u0004\"A\n\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u0015\u0011,\u0007/\u001a8eK:\u001c\u0017P\u0003\u0002\u0011'%\u00111f\n\u0002\u0017%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0017i^1sKB\u0011QFL\u0007\u0002\u001f%\u0011qf\u0004\u0002 \u0003B\u0004H.[2bi&|g.\u00118e\u000b:4\u0018N]8o[\u0016tGOR5mi\u0016\u0014\bCA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005)\u0014\u0001C4sSjTH.\u001a3\n\u0005]\u0012$a\u0002'pO\u001eLgnZ\u0001\u0012e\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,W#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\u001a\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011q\b\u0010\u0002\u0012%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0017A\u0005:fa>\u001c\u0018\u000e^8ssN+'O^5dK\u0002\n!d^3cQ>|7nU3sm&\u001cWMU3tiR+W\u000e\u001d7bi\u0016\u0004\"a\u0011'\u000e\u0003\u0011S!!\u0012$\u0002\r\rd\u0017.\u001a8u\u0015\t9\u0005*A\u0002xK\nT!!\u0013&\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aS\u0001\u0004_J<\u0017BA'E\u00051\u0011Vm\u001d;UK6\u0004H.\u0019;fQ\u0011\u0019q*\u0017.\u0011\u0005A;V\"A)\u000b\u0005I\u001b\u0016AC1o]>$\u0018\r^5p]*\u0011A+V\u0001\bM\u0006\u001cGo\u001c:z\u0015\t1\u0006*A\u0003cK\u0006t7/\u0003\u0002Y#\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002\u0003\u00061A(\u001b8jiz\"2!\u00180`!\t\u0011\u0003\u0001C\u00039\t\u0001\u0007!\bC\u0003B\t\u0001\u0007!\t\u000b\u0003`\u001ffS\u0006F\u0001\u0003c!\t\u00016-\u0003\u0002e#\nI\u0011)\u001e;po&\u0014X\rZ\u0001\f\u0007>tG/\u001a8u)f\u0004X-F\u0001h\u001f\u0005A\u0017%A5\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0017\u0001D\"p]R,g\u000e\u001e+za\u0016\u0004\u0013\u0001B:f]\u0012$\"!\u001c9\u0011\u0005qq\u0017BA8\u001e\u0005\u0011)f.\u001b;\t\u000bE<\u0001\u0019\u0001:\u0002\u000bM$\u0018\r^3\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018a\u00013u_*\u0011q/E\u0001\u0007KZ,g\u000e^:\n\u0005e$(!I!qa2L7-\u0019;j_:$U\r\u001d7ps6,g\u000e\u001e)bG.\fw-Z*uCR,GCA7|\u0011\u0015a\b\u00021\u0001~\u0003i!W\r\u001d7ps\u0016$\u0017\t\u001d9mS\u000e\fG/[8o!\u0006\u001c7.Y4f!\t\u0019h0\u0003\u0002\u0000i\nQB)\u001a9m_f,G-\u00119qY&\u001c\u0017\r^5p]B\u000b7m[1hK\u0006Qq-\u001a;TKJ4XM]:\u0016\u0005\u0005\u0015\u0001CBA\u0004\u0003/\tiB\u0004\u0003\u0002\n\u0005Ma\u0002BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=\u0011$\u0001\u0004=e>|GOP\u0005\u0002=%\u0019\u0011QC\u000f\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005\r\u0019V-\u001d\u0006\u0004\u0003+i\u0002\u0003BA\u0010\u0003ci!!!\t\u000b\t\u0005\r\u0012QE\u0001\bo\u0016\u0014\u0007n\\8l\u0015\u0011\t9#!\u000b\u0002\r\u0011,\u0007\u000f\\8z\u0015\u0011\tY#!\f\u0002\u000f\u0011Lw-\u001b;bY*\u0011\u0011qF\u0001\u0003C&LA!a\r\u0002\"\tiq+\u001a2i_>\\7+\u001a:wKJ\fa\"\u001a=fGV$XMU3rk\u0016\u001cH/\u0006\u0003\u0002:\u0005\rCcB7\u0002<\u0005U\u0013\u0011\u000e\u0005\b\u0003{Q\u0001\u0019AA \u0003-\u0011X-];fgR\u0014u\u000eZ=\u0011\t\u0005\u0005\u00131\t\u0007\u0001\t\u001d\t)E\u0003b\u0001\u0003\u000f\u0012\u0011\u0001V\t\u0005\u0003\u0013\ny\u0005E\u0002\u001d\u0003\u0017J1!!\u0014\u001e\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001HA)\u0013\r\t\u0019&\b\u0002\u0004\u0003:L\bbBA,\u0015\u0001\u0007\u0011\u0011L\u0001\u000fCB\u0004H.[2bi&|g.V5e!\u0011\tY&a\u0019\u000f\t\u0005u\u0013q\f\t\u0004\u0003\u0017i\u0012bAA1;\u00051\u0001K]3eK\u001aLA!!\u001a\u0002h\t11\u000b\u001e:j]\u001eT1!!\u0019\u001e\u0011\u001d\tYG\u0003a\u0001\u00033\na\"\u001a8wSJ|g.\\3oiVKG-A\u0005tK:$\u0017i]=oGV!\u0011\u0011OAN)\u0019\t\u0019(a%\u0002\u0018B1\u0011QOAB\u0003\u000fk!!a\u001e\u000b\t\u0005e\u00141P\u0001\u000bG>t7-\u001e:sK:$(\u0002BA?\u0003\u007f\nA!\u001e;jY*\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0006\u0006]$!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!\u0011\u0011RAH\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006}\u0014\u0001\u00027b]\u001eLA!!%\u0002\f\n!ak\\5e\u0011\u001d\t)j\u0003a\u0001\u0003;\taa]3sm\u0016\u0014\bbBA\u001f\u0017\u0001\u0007\u0011\u0011\u0014\t\u0005\u0003\u0003\nY\nB\u0004\u0002F-\u0011\r!a\u0012)\u0007\u0001\ty\n\u0005\u0003\u0002\"\u0006\u001dVBAAR\u0015\r\t)\u000bS\u0001\u000bgR,'/Z8usB,\u0017\u0002BAU\u0003G\u0013qaU3sm&\u001cW\r")
public class WebhookDeploymentPackageStatusClient
implements DeploymentPackageStatusService,
RepositoryServiceAware,
ApplicationAndEnvironmentFilter,
Logging {
    private final RepositoryService repositoryService;
    @Qualifier(value="webhookServiceRestTemplate")
    private final RestTemplate webhookServiceRestTemplate;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public boolean matchAppEnvToDeploymentRegexp(WebhookServer webhookServer, String applicationId, String environmentId) {
        return ApplicationAndEnvironmentFilter.matchAppEnvToDeploymentRegexp$(this, webhookServer, applicationId, environmentId);
    }

    public <CI extends ConfigurationItem> SearchParameters typedSearchParameters(ClassTag<CI> evidence$1) {
        return RepositoryServiceAware.typedSearchParameters$((RepositoryServiceAware)this, evidence$1);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WebhookDeploymentPackageStatusClient webhookDeploymentPackageStatusClient = this;
        synchronized (webhookDeploymentPackageStatusClient) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public final String ContentType() {
        return "application/json";
    }

    @Override
    public void send(ApplicationDeploymentPackageState state) {
        this.executeRequest(state, state.applicationUid(), state.state().destinationUid());
    }

    @Override
    public void send(DeployedApplicationPackage deployedApplicationPackage) {
        this.executeRequest(deployedApplicationPackage, deployedApplicationPackage.applicationUid(), deployedApplicationPackage.destinationUid());
    }

    private Seq<WebhookServer> getServers() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.repositoryService().listEntities(this.typedSearchParameters(ClassTag$.MODULE$.apply(WebhookServer.class)))).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.enabled()))).toVector();
    }

    private <T> void executeRequest(T requestBody, String applicationUid, String environmentUid) {
        String appId = ((BaseConfigurationItem)this.repositoryService().readByReferenceId(applicationUid)).getId();
        String envId = ((BaseConfigurationItem)this.repositoryService().readByReferenceId(environmentUid)).getId();
        ((IterableOnceOps)this.getServers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)this.matchAppEnvToDeploymentRegexp(server, appId, envId)))).foreach((Function1 & Serializable)x$7 -> this.sendAsync((WebhookServer)x$7, requestBody));
    }

    private <T> CompletableFuture<Void> sendAsync(WebhookServer server, T requestBody) {
        return CompletableFuture.runAsync(() -> {
            LinkedMultiValueMap headers = new LinkedMultiValueMap();
            if (!server.noAuthentication()) {
                headers.add((Object)server.tokenHeader(), (Object)server.tokenValue());
            }
            headers.add((Object)"Content-Type", (Object)"application/json");
            $this.webhookServiceRestTemplate.exchange(server.webhookServerURL(), HttpMethod.POST, new HttpEntity(requestBody, (MultiValueMap)headers), Void.class, new Object[0]);
        }).whenComplete((x$8, ex) -> {
            Option option = Option$.MODULE$.apply(ex);
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable exception = (Throwable)some.value();
                this.logger().warn((Function0 & Serializable)() -> "An error occurred when sending webhook event to " + server.webhookServerURL() + ": " + exception.getMessage());
                return;
            }
            throw new MatchError((Object)option);
        });
    }

    @Autowired
    public WebhookDeploymentPackageStatusClient(RepositoryService repositoryService, @Qualifier(value="webhookServiceRestTemplate") RestTemplate webhookServiceRestTemplate) {
        this.repositoryService = repositoryService;
        this.webhookServiceRestTemplate = webhookServiceRestTemplate;
        RepositoryServiceAware.$init$((RepositoryServiceAware)this);
        ApplicationAndEnvironmentFilter.$init$(this);
        Logging.$init$((Logging)this);
    }
}

