package com.xebialabs.deployit.core.rest.api

import com.fasterxml.jackson.core.`type`.TypeReference
import com.fasterxml.jackson.databind.ObjectMapper
import com.xebialabs.deployit.core.api.PendoConfigurationService
import com.xebialabs.deployit.core.service.PendoMetadataService
import org.apache.commons.lang3.StringUtils
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util

@Service
class PendoConfigurationServiceImpl extends PendoConfigurationService {

  @Autowired
  var pendoMetadataService: PendoMetadataService = _

  override def getProperties: util.Map[String, Object] = {
    val properties = new util.HashMap[String, Object]
    val pendoAccountMetadata = pendoMetadataService.getPendoAccountMetaData()
    if (StringUtils.isNotEmpty(pendoAccountMetadata)) {
      properties.putAll(new ObjectMapper().readValue(pendoAccountMetadata, new TypeReference[util.HashMap[String,Object]]() {}))
    }
    pendoMetadataService.upsertPendoAccountMetadata("")
    properties
  }
}
