package com.xebialabs.deployit.core.rest.mappers;

import ai.digital.configuration.central.deploy.ClientProperties;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

// PLEASE NOTE: Do not remove the implemented interface, it is needed by RestEasy, even though the ClosingExceptionMapper also implements it.
@Provider
@Component
public class UnhandledExceptionMapper extends ClosingExceptionMapper<RuntimeException> implements ExceptionMapper<RuntimeException> {

    private static final Logger logger = LoggerFactory.getLogger(UnhandledExceptionMapper.class);

    private final DeployitExceptionMapper deployitHandler;

    @Autowired
    public UnhandledExceptionMapper(ClientProperties config) {
        super(config.hideInternals());
        deployitHandler = new DeployitExceptionMapper(XStreamReaderWriter.getConfiguredXStream(), config);
    }

    @Override
    protected Response handleException(RuntimeException exception) {

        // Safeguard that we do not by accident handle DeployitExceptions
        if (exception instanceof DeployitException) {
            return deployitHandler.toResponse((DeployitException) exception);
        }

        logger.error("Unhandled Exception: {}", exception);

        String content = Exceptions.getAllMessages(exception);
        int status = 500;
        Response handled = checkWhetherWeHideInternals(status, exception, content);

        if (handled != null) {
            return handled;
        }

        final Response.ResponseBuilder builder = Response.serverError().type(MediaType.TEXT_PLAIN);
        builder.header("X-Unhandled-Exception", "true");
        builder.header(X_EXCEPTION_TYPE, exception.getClass().getName());
        builder.header(X_PATH, PathInterceptor.PATH.get());
        builder.entity(Sanitizer.sanitize(content));
        return builder.build();
    }
}
