/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.json.SatelliteInfoJsonConverter;
import com.xebialabs.xltype.serialization.rest.TypeMatcher;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class SatelliteInfoListJsonWriter
implements MessageBodyWriter<Collection<SatelliteInfo>> {
    private final TypeMatcher matcher = new TypeMatcher(Collection.class, new Class[]{SatelliteInfo.class});
    private final SatelliteInfoJsonConverter satelliteInfoJsonConverter = new SatelliteInfoJsonConverter();

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.matcher.matches(type, genericType);
    }

    public long getSize(Collection<SatelliteInfo> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Collection<SatelliteInfo> satelliteInfos, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(satelliteInfos).getBytes());
    }

    @VisibleForTesting
    String toJson(Collection<SatelliteInfo> satelliteInfos) {
        JsonWriter writer = new JsonWriter();
        writer.array();
        for (SatelliteInfo satelliteInfo : satelliteInfos) {
            this.satelliteInfoJsonConverter.toJson(satelliteInfo, writer);
        }
        writer.endArray();
        return writer.toString();
    }
}

