/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.core.common.security.permission.DeployitPermissions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.AbstractTaskResource;
import com.xebialabs.deployit.core.rest.api.DeploymentObjectGenerator;
import com.xebialabs.deployit.core.rest.api.DeploymentUtils;
import com.xebialabs.deployit.core.rest.api.DeploymentWriter;
import com.xebialabs.deployit.core.rest.api.InvalidDeploymentException;
import com.xebialabs.deployit.core.rest.api.PermissionChecker;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.SelectedDeployment;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.deployit.engine.spi.event.TaskCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskStartedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.PreviewStepAdapter;
import com.xebialabs.deployit.engine.tasker.StepBlock;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.event.DeployedChangeEventHandler;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFolderArtifact;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.file.FileCopyStrategy;
import com.xebialabs.deployit.plugin.overthere.CopyStrategyName;
import com.xebialabs.deployit.plugin.overthere.DefaultCopyStrategyName;
import com.xebialabs.deployit.repository.DictionaryRepository;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeployedService;
import com.xebialabs.deployit.service.deployment.DeploymentTaskService;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.deployment.ResolvedPlaceholderGenerator;
import com.xebialabs.deployit.service.deployment.RollbackService;
import com.xebialabs.deployit.service.deployment.TaskSpecificationService;
import com.xebialabs.deployit.service.externalproperties.ExternalPropertiesResolver;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.spring.BeanWrapper;
import com.xebialabs.deployit.util.StreamFactoryUtil;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlplatform.config.ConfigurationHolder;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DeploymentTaskServiceImpl
extends AbstractTaskResource
implements DeploymentTaskService {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    @Qualifier(value="externalPropertiesResolverImpl")
    private ExternalPropertiesResolver externalPropertiesResolver;
    @Autowired
    private DeployedService deployedService;
    @Autowired
    private RollbackService rollbackService;
    @Autowired
    private BeanWrapper<TaskExecutionEngine> engine;
    @Autowired
    private Validator validator;
    @Autowired
    private PermissionChecker permissionChecker;
    @Autowired
    private DeploymentObjectGenerator deploymentObjectGenerator;
    @Autowired
    @Qualifier(value="taskSpecificationService")
    private TaskSpecificationService taskSpecificationService;
    @Autowired
    private DictionaryRepository dictionaryRepository;
    private final Cache<String, PreviewWithWorkdir<?>> previewCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new PreviewCleaner()).build();
    private static final List<String> TAR_ARCHIVE_TYPES = Arrays.asList("tar", "tar.gz", "tar.bz2");
    private static final List<String> ZIP_ARCHIVE_TYPES = Arrays.asList("zip", "jar");
    private static final List<String> ZIP_STRATEGIES = Arrays.asList("ZipWindows", "ZipUnix", "Zip");
    private static final Logger logger = LoggerFactory.getLogger(DeploymentTaskServiceImpl.class);

    @PreDestroy
    private void cleanCache() {
        this.previewCache.invalidateAll();
        this.previewCache.cleanUp();
    }

    public boolean isDeployed(String applicationId, String environmentId) {
        logger.trace("isDeployed {}, {}", (Object)applicationId, (Object)environmentId);
        Checks.checkNotNull((Object)applicationId, (String)"application");
        Checks.checkNotNull((Object)environmentId, (String)"environment");
        this.checkCiExists(applicationId);
        this.checkCiExists(environmentId);
        return this.repositoryService.exists(IdGenerator.generateId((String)environmentId, (String)applicationId));
    }

    public Deployment prepareInitial(String versionId, String environmentId) {
        this.previewCache.cleanUp();
        logger.trace("prepareInitial {}, {}", (Object)versionId, (Object)environmentId);
        Checks.checkNotNull((Object)versionId, (String)"version");
        Checks.checkNotNull((Object)environmentId, (String)"environment");
        Version version = DeploymentUtils.checkAndCast(this.repositoryService.read(versionId), Version.class);
        Environment env = DeploymentUtils.checkAndCast(this.repositoryService.read(environmentId), Environment.class);
        this.externalPropertiesResolver.resolveExternalProperties(new ConfigurationItem[]{version, env});
        this.permissionChecker.checkPermission(DeployitPermissions.DEPLOY_INITIAL(), env);
        return this.deploymentObjectGenerator.forInitial(version, env);
    }

    public Deployment prepareUpdate(String versionId, String deployedApplicationId) {
        this.previewCache.cleanUp();
        logger.trace("prepareUpgrade {}, {}", (Object)versionId, (Object)deployedApplicationId);
        Checks.checkNotNull((Object)versionId, (String)"version");
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        DeployedApplication deployedApplication = DeploymentUtils.checkAndCast(this.repositoryService.read(deployedApplicationId), DeployedApplication.class);
        Environment env = deployedApplication.getEnvironment();
        this.permissionChecker.checkPermission(DeployitPermissions.DEPLOY_UPGRADE(), env);
        Version newVersion = DeploymentUtils.checkAndCast(this.repositoryService.read(versionId), Version.class);
        this.externalPropertiesResolver.resolveExternalProperties(new ConfigurationItem[]{deployedApplication, newVersion, env});
        return this.deploymentObjectGenerator.forUpdate(deployedApplication, newVersion, env);
    }

    public Deployment prepareAutoDeployeds(Deployment deployment) {
        this.previewCache.cleanUp();
        logger.trace("updateDeployeds {}", (Object)deployment);
        DeployedApplication deployedApplication = this.preGenerateCheck(deployment);
        Version version = deployedApplication.getVersion();
        Environment environment = deployedApplication.getEnvironment();
        this.deployedService.scanMissingPlaceholders(deployedApplication, environment);
        List additionalDeployeds = this.deployedService.createDeployedsForNonExistingCombinations(deployment, version, environment, DeploymentTaskServiceImpl.getDeployeds(deployment), new HashMap());
        this.permissionChecker.checkPermission(deployment, deployment.getGroupedRequiredDeployments());
        List updatedRequiredDeployments = deployment.getGroupedRequiredDeployments().stream().map(s -> s.stream().map(this::prepareAutoDeployeds).collect(Collectors.toList())).collect(Collectors.toList());
        deployment.setGroupedRequiredDeployments(updatedRequiredDeployments);
        deployment.getDeployeds().clear();
        deployment.getResolvedPlaceholders().addAll(deployedApplication.get$ResolvedPlaceholders());
        deployment.addAll(DeploymentWriter.convertDeployeds(additionalDeployeds));
        this.overrideValidationMessages(deployment);
        return deployment;
    }

    private void overrideValidationMessages(Deployment deployment) {
        ArrayList<ValidationMessage> overrideMessages = new ArrayList<ValidationMessage>();
        Environment environment = null;
        ArrayList deployeds = Lists.newArrayList((Iterable)deployment.getDeployeds());
        for (Deployment d : deployment.getRequiredDeployments()) {
            deployeds.addAll(d.getDeployeds());
        }
        ConfigurationItem deployedApplication = deployment.getDeployedApplication();
        if (deployedApplication instanceof DeployedApplication) {
            environment = ((DeployedApplication)deployedApplication).getEnvironment();
        }
        boolean failWhenMissingPropertyPlaceholder = false;
        if (environment != null) {
            failWhenMissingPropertyPlaceholder = (Boolean)environment.getProperty("failWhenCiPropertyMissingPlaceholderValue");
        }
        if (failWhenMissingPropertyPlaceholder) {
            for (ConfigurationItem deployed : deployeds) {
                for (ValidationMessage message : deployed.get$validationMessages()) {
                    Object value;
                    Deployable deployable;
                    String propertyName = message.getPropertyName();
                    PropertyDescriptor pd = deployed.getType().getDescriptor().getPropertyDescriptor(propertyName);
                    if (pd == null || !pd.getKind().equals((Object)PropertyKind.INTEGER) && !pd.getKind().equals((Object)PropertyKind.STRING) || !(deployed instanceof Deployed) || (deployable = ((Deployed)deployed).getDeployable()) == null || !deployable.hasProperty(propertyName) || (value = deployable.getProperty(propertyName)) == null || !message.getLevel().equals((Object)ValidationMessage.Level.WARNING) || !message.getMessage().startsWith("Could not resolve the property value(s) \"" + String.valueOf(value) + "\" using the dictionary")) continue;
                    overrideMessages.add(message);
                }
                for (ValidationMessage message : overrideMessages) {
                    deployed.get$validationMessages().remove(message);
                    deployed.get$validationMessages().add(ValidationMessage.error((String)message.getCiId(), (String)message.getPropertyName(), (String)message.getMessage()));
                }
                overrideMessages.clear();
            }
        }
    }

    protected String getDefaultCopyStrategyFromDeployed(ConfigurationItem deployable) {
        FileCopyStrategy defaultCopyStrategy;
        FileCopyStrategy fileCopyStrategy = defaultCopyStrategy = deployable.hasProperty("defaultCopyStrategy") ? (FileCopyStrategy)deployable.getProperty("defaultCopyStrategy") : null;
        if (defaultCopyStrategy != null) {
            DefaultCopyStrategyName defaultCopyStrategyFolder = defaultCopyStrategy.getDefaultCopyStrategy();
            return defaultCopyStrategyFolder != null ? defaultCopyStrategyFolder.name() : null;
        }
        logger.debug("No default copy strategy name found for deployable: {}", (Object)deployable.getId());
        return null;
    }

    protected String getInfraCopyStrategy(ConfigurationItem deployed) {
        ConfigurationItem deployedContainer;
        if (deployed.hasProperty("container") && (deployedContainer = (ConfigurationItem)deployed.getProperty("container")) != null) {
            CopyStrategyName copyStrategy = deployedContainer.hasProperty("copyStrategy") ? (CopyStrategyName)deployedContainer.getProperty("copyStrategy") : this.getHostCopyStrategy(deployedContainer);
            return copyStrategy != null ? copyStrategy.name() : null;
        }
        return null;
    }

    protected CopyStrategyName getHostCopyStrategy(ConfigurationItem deployedContainer) {
        ConfigurationItem host;
        if (deployedContainer.hasProperty("host") && (host = (ConfigurationItem)deployedContainer.getProperty("host")) != null && host.hasProperty("copyStrategy")) {
            return (CopyStrategyName)host.getProperty("copyStrategy");
        }
        return null;
    }

    protected void validateFolderCopyStrategy(List<ConfigurationItem> deployeds) {
        for (ConfigurationItem deployed : deployeds) {
            if (!deployed.hasProperty("deployable")) continue;
            ConfigurationItem deployable = (ConfigurationItem)deployed.getProperty("deployable");
            if (deployable instanceof BaseDeployableFolderArtifact) {
                String autodetectSetting;
                Config config = this.getConfig();
                boolean autodetect = config.hasPath(autodetectSetting = "deploy.task.artifact-copy-strategy.autodetect") && config.getBoolean(autodetectSetting);
                String infraCopyStrategyFound = this.getInfraCopyStrategy(deployed);
                this.warnIfCopyStrategyIsOneByOne(deployed, deployable, autodetect, infraCopyStrategyFound);
                this.errorIfCopyStrategyIsIncompatible(deployed, deployable, autodetect, infraCopyStrategyFound);
                continue;
            }
            logger.debug("No default copy strategy found for deployable: {}.", (Object)deployable.getId());
        }
    }

    protected Config getConfig() {
        return ConfigurationHolder.get();
    }

    protected void warnIfCopyStrategyIsOneByOne(ConfigurationItem deployed, ConfigurationItem deployable, boolean autodetect, String infraCopyStrategyFound) {
        List<String> copyStrategies = this.getCopyStrategiesWithoutAutoDetectForValidate(deployed, autodetect, infraCopyStrategyFound);
        if (!autodetect && (copyStrategies.isEmpty() || copyStrategies.contains("OneByOne"))) {
            DeploymentTaskServiceImpl.warningMessage(deployed);
        }
    }

    protected void errorIfCopyStrategyIsIncompatible(ConfigurationItem deployed, ConfigurationItem deployable, boolean autodetect, String infraCopyStrategyFound) {
        Set members;
        int stripComponents = deployed.hasProperty("stripComponents") ? Integer.parseInt(deployed.getProperty("stripComponents").toString()) : 0;
        Set set = members = deployed.hasProperty("members") ? (Set)deployed.getProperty("members") : null;
        if (infraCopyStrategyFound != null) {
            if (this.isIncompatibleZipStrategy(infraCopyStrategyFound, stripComponents, members)) {
                DeploymentTaskServiceImpl.errorMessage(deployed);
            }
        } else if (autodetect) {
            this.validateCopyStrategiesOnAutoDetect(deployed, deployable, stripComponents, members);
        } else {
            this.validateDefaultCopyStrategyForIncompatible(deployed, deployable, stripComponents, members);
        }
    }

    protected static void warningMessage(ConfigurationItem deployed) {
        String warningMessage = "OneByOne is detected as the default copy strategy. This approach can significantly impact performance and is not recommended.";
        deployed.get$validationMessages().add(ValidationMessage.warn((String)deployed.getId(), (String)"defaultCopyStrategy", (String)warningMessage));
    }

    protected List<String> getCopyStrategiesWithoutAutoDetectForValidate(ConfigurationItem deployed, boolean autodetect, String infraCopyStrategyFound) {
        ArrayList<String> copyStrategies = new ArrayList<String>();
        if (infraCopyStrategyFound != null) {
            logger.debug("Using infra copy strategy: {}", (Object)infraCopyStrategyFound);
            copyStrategies.add(infraCopyStrategyFound);
        } else if (!autodetect) {
            this.addDefaultCopyStrategyIfFound(deployed, copyStrategies);
        }
        return copyStrategies;
    }

    protected void validateCopyStrategiesOnAutoDetect(ConfigurationItem deployed, ConfigurationItem deployable, int stripComponents, Set<String> members) {
        BaseDeployableFolderArtifact folderArtifact = (BaseDeployableFolderArtifact)deployable;
        OverthereFile sourceFile = folderArtifact.getFile();
        if (sourceFile != null && sourceFile.exists()) {
            boolean tarOptionsApplied;
            String sourceFileName = sourceFile.getName();
            boolean bl = tarOptionsApplied = stripComponents > 0 || members != null && !members.isEmpty();
            if (this.isZipArchiveTypeFromFolderName(sourceFileName) && tarOptionsApplied) {
                DeploymentTaskServiceImpl.errorMessage(deployed);
            } else if (!this.isTarArchiveTypeFromFolderName(sourceFileName) && tarOptionsApplied) {
                this.validateDefaultCopyStrategyForIncompatible(deployed, deployable, stripComponents, members);
            }
        } else {
            logger.debug("No file found for deployable: {}. Cannot determine autodetect copy strategy.", (Object)deployable.getId());
        }
    }

    protected void validateDefaultCopyStrategyForIncompatible(ConfigurationItem deployed, ConfigurationItem deployable, int stripComponents, Set<String> members) {
        String defaultCopyStrategyFolderFound = this.getDefaultCopyStrategyFromDeployed(deployed);
        if (defaultCopyStrategyFolderFound != null && this.isIncompatibleZipStrategy(defaultCopyStrategyFolderFound, stripComponents, members)) {
            DeploymentTaskServiceImpl.errorMessage(deployed);
        }
    }

    protected void addDefaultCopyStrategyIfFound(ConfigurationItem deployed, List<String> copyStrategies) {
        String defaultCopyStrategyFolderFound = this.getDefaultCopyStrategyFromDeployed(deployed);
        if (defaultCopyStrategyFolderFound != null) {
            logger.debug("Using default copy strategy: {}", (Object)defaultCopyStrategyFolderFound);
            copyStrategies.add(defaultCopyStrategyFolderFound);
        }
    }

    private static void errorMessage(ConfigurationItem deployed) {
        String errorMessage = "The selected Zip copy strategy for this deployment is incompatible with the defined Strip Components and/or members properties. To proceed, either change the copy strategy to Tar or remove the Strip Components and/or Members properties.";
        deployed.get$validationMessages().add(ValidationMessage.error((String)deployed.getId(), (String)"CopyStrategy", (String)errorMessage));
    }

    protected boolean isIncompatibleZipStrategy(String strategy, int stripComponents, Set<String> members) {
        boolean isZip = ZIP_STRATEGIES.contains(strategy);
        boolean hasIncompatibleProps = stripComponents > 0 || members != null && !members.isEmpty();
        return isZip && hasIncompatibleProps;
    }

    protected boolean isTarArchiveTypeFromFolderName(String folderName) {
        String archiveType = StreamFactoryUtil.fetchStreamFactory().getArchiveType(folderName);
        boolean isTar = TAR_ARCHIVE_TYPES.contains(archiveType);
        logger.debug("[isTarArchiveTypeFromFolderName] Checking archive type for folder '{}': detected '{}', isTar={}", new Object[]{folderName, archiveType, isTar});
        return isTar;
    }

    protected boolean isZipArchiveTypeFromFolderName(String folderName) {
        String archiveType = StreamFactoryUtil.fetchStreamFactory().getArchiveType(folderName);
        boolean isZip = ZIP_ARCHIVE_TYPES.contains(archiveType);
        logger.debug("[isZipArchiveTypeFromFolderName] Checking archive type for folder '{}': detected '{}', isZip={}", new Object[]{folderName, archiveType, isZip});
        return isZip;
    }

    public String createTask(Deployment deployment) {
        this.checkDeploymentInput(deployment);
        if (this.isNotValidDeploymentWithValidator(deployment)) {
            throw new InvalidDeploymentException(deployment);
        }
        this.invalidatePreview(deployment);
        logger.trace("Creating task for {}", (Object)deployment);
        this.warnAboutUsingDeprecatedCI(deployment);
        ResolvedPlaceholderGenerator.generateAndAdd((Deployment)deployment);
        TaskSpecification deploymentTask = this.taskSpecificationService.createDeploymentTask(deployment, false);
        String taskId = ((TaskExecutionEngine)this.engine.get()).register(deploymentTask);
        logger.debug("Registered {} task {} for Deployed Application {}", new Object[]{deployment.getDeploymentType(), taskId, deployment.getDeployedApplication().getId()});
        EventBusHolder.publish((Object)new TaskCreatedEvent(taskId, deployment.getDeploymentType().toString(), deployment.getDeployedApplication().getId()));
        this.notifyChangesInDeployeds(taskId, deployment);
        return taskId;
    }

    private void notifyChangesInDeployeds(String taskId, Deployment deployment) {
        Version version = (Version)deployment.getDeployedApplication().getProperty("version");
        Environment environment = (Environment)deployment.getDeployedApplication().getProperty("environment");
        List<Deployed> existingDeployeds = ((DeployedApplication)deployment.getDeployedApplication()).getDeployeds().stream().flatMap(deployed -> this.deployedService.createSelectedDeployed(deployment, deployed.getDeployable(), deployed.getContainer(), deployed.getType(), version, environment).getDeployeds().stream().filter(existingDeployed -> existingDeployed.getId().equals(deployed.getId()))).collect(Collectors.toList());
        DeployedChangeEventHandler.notifyDeployedPropertiesChange((String)taskId, (List)deployment.getDeployeds(), DeploymentWriter.convertDeployeds(existingDeployeds));
    }

    public void startDeploymentTask(String taskId) {
        this.checkOwnership(taskId);
        this.taskQueueService.enqueueTask(taskId);
        EventBusHolder.publish((Object)new TaskStartedEvent(taskId));
    }

    public Deployment prepareUndeploy(String deployedApplicationId) {
        this.previewCache.cleanUp();
        logger.trace("prepareUndeployApplication {}", (Object)deployedApplicationId);
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        DeployedApplication deployedApplication = DeploymentUtils.checkAndCast(this.repositoryService.read(deployedApplicationId, 2), DeployedApplication.class);
        this.checkPermission(DeployitPermissions.UNDEPLOY(), deployedApplication.getEnvironment().getId());
        Deployment unDeployment = DeploymentWriter.createDeployment(deployedApplication, Deployment.DeploymentType.UNDEPLOYMENT);
        this.taskSpecificationService.applyUnDeploymentGroups(deployedApplication, unDeployment);
        return unDeployment;
    }

    public Deployment generateSelectedDeployeds(SelectedDeployment selectedDeployment) {
        this.previewCache.cleanUp();
        List deployableIds = selectedDeployment.getSelectedDeployableIds();
        Checks.checkArgument((!deployableIds.isEmpty() ? 1 : 0) != 0, (String)"Should select at least one deployable to generate a deployed", (Object[])new Object[0]);
        Deployment deployment = selectedDeployment.getDeployment();
        logger.trace("generateSelectedDeployeds {}, {}", (Object)deployableIds, (Object)deployment);
        DeployedApplication deployedApplication = this.preGenerateCheck(deployment);
        Version version = deployedApplication.getVersion();
        logger.debug("Generating deployeds from package [{}]", (Object)version);
        Set allDeployables = deployment.getRequiredDeployments().stream().map(this::preGenerateCheck).map(DeployedApplication::getVersion).flatMap(dependencyVersion -> dependencyVersion.getDeployables().stream()).collect(Collectors.toCollection(() -> new HashSet(version.getDeployables())));
        ImmutableMap deployables = Maps.uniqueIndex((Iterable)allDeployables, ConfigurationItem::getId);
        List deployableCIs = deployableIds.stream().peek(arg_0 -> DeploymentTaskServiceImpl.lambda$generateSelectedDeployeds$5((Map)deployables, arg_0)).map(((Map)deployables)::get).collect(Collectors.toList());
        Environment environment = deployedApplication.getEnvironment();
        this.deployedService.scanMissingPlaceholders(deployedApplication, environment);
        GeneratedDeployeds selectedDeployeds = this.deployedService.generateSelectedDeployeds(deployment, deployableCIs, version, environment);
        deployment.addAll(DeploymentWriter.convertDeployeds(selectedDeployeds.getDeployeds()));
        this.overrideValidationMessages(deployment);
        return deployment;
    }

    public Deployment generateSingleDeployed(String deployableId, String containerId, Type deployedType, Deployment deployment) {
        this.previewCache.cleanUp();
        logger.debug("Creating explicit deployed for [{}] and [{}]", (Object)deployableId, (Object)containerId);
        DeployedApplication deployedApplication = this.preGenerateCheck(deployment);
        Version version = deployedApplication.getVersion();
        Environment environment = deployedApplication.getEnvironment();
        Checks.checkNotNull((Object)deployableId, (String)"deployable");
        Checks.checkNotNull((Object)containerId, (String)"container");
        Deployable deployable = DeploymentUtils.checkAndCast((ConfigurationItem)Iterables.find(this.collectDeployables(deployment), input -> input.getId().equals(deployableId)), Deployable.class);
        Container container = DeploymentUtils.checkAndCast((ConfigurationItem)Iterables.find((Iterable)environment.getMembers(), input -> input.getId().equals(containerId)), Container.class);
        GeneratedDeployeds selectedDeployed = this.deployedService.createSelectedDeployed(deployment, deployable, container, deployedType, version, environment);
        deployment.addAll(DeploymentWriter.convertDeployeds(selectedDeployed.getDeployeds()));
        this.overrideValidationMessages(deployment);
        return deployment;
    }

    public TaskPreviewBlock taskPreviewBlock(Deployment deployment) {
        this.checkDeploymentInput(deployment);
        try {
            this.invalidatePreview(deployment);
            PreviewWithWorkdir<TaskPreviewBlock> preview = this.getTaskPreview(deployment, WorkdirHolder.get(), new TaskPreviewBlockBuilder());
            return preview.getPreview();
        }
        catch (Exception e) {
            throw new DeployitException((Throwable)e, "Error getting task preview for deployment [%s]", new Object[]{deployment.getId()});
        }
    }

    public StepState taskPreviewBlock(Deployment deployment, String blockId, int stepNr) {
        this.checkDeploymentInput(deployment);
        try {
            this.invalidatePreview(deployment);
            PreviewWithWorkdir<TaskPreviewBlock> preview = this.getTaskPreview(deployment, WorkdirHolder.get(), new TaskPreviewBlockBuilder());
            Block topBlock = (Block)preview.getPreview().getBlock();
            BlockState child = (BlockState)topBlock.getBlock(BlockPath.apply((String)blockId).tail()).getOrElse(null);
            if (!(child instanceof StepBlock)) {
                throw new DeployitException("Block [%s] is a composite block so it has no steps", new Object[]{blockId});
            }
            List steps = ((StepBlock)child).getSteps();
            Checks.checkArgument((stepNr > 0 && stepNr <= steps.size() ? 1 : 0) != 0, (String)"Not a valid step number [%s]", (Object[])new Object[]{stepNr});
            StepState stepState = (StepState)steps.get(stepNr - 1);
            if (this.hasPermission(DeployitPermissions.TASK_PREVIEWSTEP())) {
                return new PreviewStepAdapter((TaskStep)stepState);
            }
            return stepState;
        }
        catch (Exception e) {
            throw new DeployitException((Throwable)e, "Error getting task preview for deployment [%s]", new Object[]{deployment.getId()});
        }
    }

    public String rollback(String taskid) {
        Task task = ((TaskExecutionEngine)this.engine.get()).retrieveTask(taskid);
        return this.rollbackService.rollback(task);
    }

    public Map<String, String> effectiveDictionary(String environment, String applicationVersion, String application, String container) {
        return this.dictionaryRepository.getDictionariesForEnv(environment, application, container, applicationVersion);
    }

    private DeployedApplication preGenerateCheck(Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.invalidatePreview(deployment);
        return (DeployedApplication)deployment.getDeployedApplication();
    }

    private void invalidatePreview(Deployment deployment) {
        this.previewCache.cleanUp();
        if (deployment.getId() != null) {
            this.previewCache.invalidate((Object)deployment.getId());
        }
    }

    private List<Deployable> collectDeployables(Deployment deployment) {
        Stream dependantDeployables = deployment.getRequiredDeployments().stream().flatMap(depl -> ((DeployedApplication)depl.getDeployedApplication()).getVersion().getDeployables().stream());
        return Stream.concat(((DeployedApplication)deployment.getDeployedApplication()).getVersion().getDeployables().stream(), dependantDeployables).collect(Collectors.toList());
    }

    public Deployment validate(Deployment deployment) {
        this.previewCache.cleanUp();
        this.invalidatePreview(deployment);
        if (this.isNotValidDeploymentWithValidator(deployment)) {
            throw new InvalidDeploymentException(deployment);
        }
        return deployment;
    }

    private <T extends AbstractDto> PreviewWithWorkdir<T> getTaskPreview(Deployment deployment, WorkDir workDir, PreviewBuilder<T> builder) throws ExecutionException {
        String id = deployment.getId();
        Checks.checkArgument((id != null ? 1 : 0) != 0, (String)"Old-style client detected, deployment does not have an 'id' set. Please upgrade your client.", (Object[])new Object[0]);
        Callable<PreviewWithWorkdir> preview = () -> {
            logger.info("Generating {} for deployment [{}]", (Object)builder, (Object)deployment.getId());
            ConfigurationItem configurationItem = this.validateDeployedApplication(deployment.getDeployedApplication());
            if (!configurationItem.get$validationMessages().isEmpty()) {
                throw new InvalidDeploymentException("The DeployedApplication contained validation errors, not generating a steps view.");
            }
            this.filterDeployedsWithValidationErrors(deployment);
            TaskSpecification taskSpecification = this.taskSpecificationService.createDeploymentTask(deployment, true);
            logger.info("Done generating {} for deployment [{}]", (Object)builder, (Object)deployment.getId());
            return builder.build(deployment.getId(), workDir, taskSpecification);
        };
        PreviewWithWorkdir possiblyCached = (PreviewWithWorkdir)this.previewCache.get((Object)id, preview);
        return possiblyCached;
    }

    private void filterDeployedsWithValidationErrors(Deployment deployment) {
        for (ConfigurationItem configurationItem : Lists.newArrayList((Iterable)deployment.getDeployeds())) {
            if (this.validator.validate(configurationItem, new ConfigurationItem[0]).isEmpty()) continue;
            logger.debug("ConfigurationItem [{} ({})] contained validation errors, not taking it into account for steps view.", (Object)configurationItem.getId(), (Object)configurationItem.getType());
            deployment.getDeployeds().remove(configurationItem);
        }
    }

    private void warnAboutUsingDeprecatedCI(Deployment deployment) {
        DeployedApplication da = (DeployedApplication)deployment.getDeployedApplication();
        if (Type.valueOf(CompositePackage.class).equals((Object)da.getVersion().getType())) {
            Deprecations.deprecated((String)"Deprecation warning: You are deploying a udm.CompositePackage [{}]. Please use application dependencies instead. Refer to the upgrade manual for more information.", (Object[])new Object[]{da.getVersion().getId()});
        }
    }

    private void checkDeploymentInput(Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.permissionChecker.checkPermission(deployment, deployment.getGroupedRequiredDeployments());
        this.checkDeployedDuplicates(deployment);
    }

    private void checkDeployedDuplicates(Deployment deployment) {
        FluentIterable deployeds = FluentIterable.from((Iterable)deployment.getRequiredDeployments()).transformAndConcat(input -> input.getDeployeds()).append((Iterable)deployment.getDeployeds());
        HashSet<String> processed = new HashSet<String>();
        for (ConfigurationItem deployed : deployeds) {
            if (!processed.contains(deployed.getId())) {
                processed.add(deployed.getId());
                continue;
            }
            throw new InvalidDeploymentException("You are trying to deploy multiple items with the same id: " + deployed.getId() + " on the same container.");
        }
    }

    private static Set<Deployed> getDeployeds(Deployment deployment) {
        List deployedEntities = deployment.getDeployeds();
        FluentIterable from = FluentIterable.from((Iterable)deployedEntities);
        Checks.checkArgument((boolean)from.allMatch(Predicates.or((Predicate)Predicates.instanceOf(Deployed.class), (Predicate)Predicates.instanceOf(EmbeddedDeployed.class))), (String)"The Deployment can only contain Deployed or EmbeddedDeployed configuration items", (Object[])new Object[0]);
        return Sets.newHashSet((Iterable)from.filter(Deployed.class));
    }

    private boolean isNotValidDeploymentWithValidator(Deployment deployment) {
        ConfigurationItem deployedApplication = this.validateDeployedApplication(deployment.getDeployedApplication());
        deployment.setDeployedApplication(deployedApplication);
        boolean deployedApplicationValid = deployedApplication.get$validationMessages().isEmpty();
        boolean deployedsValid = true;
        ArrayList cis = Lists.newArrayList((Iterable)deployment.getDeployeds());
        for (Deployment d : deployment.getRequiredDeployments()) {
            cis.addAll(d.getDeployeds());
        }
        try {
            this.validator.validateCis((List)cis);
        }
        catch (Validator.ValidationsFailedException ignored) {
            deployedsValid = false;
        }
        this.validateFolderCopyStrategy(cis);
        deployedsValid = deployedsValid && this.updateWithValidatedDeployeds(deployment);
        for (Deployment depl : deployment.getRequiredDeployments()) {
            deployedsValid = deployedsValid && this.updateWithValidatedDeployeds(depl);
        }
        return !deployedsValid || !deployedApplicationValid;
    }

    private boolean updateWithValidatedDeployeds(Deployment deployment) {
        ArrayList validatedDeployeds = Lists.newArrayList();
        boolean deployedsValid = this.validateDeployeds(deployment.getDeployeds(), validatedDeployeds);
        deployment.setDeployeds((List)validatedDeployeds);
        return deployedsValid;
    }

    private boolean validateDeployeds(List<ConfigurationItem> deployeds, List<ConfigurationItem> validated) {
        boolean deployedsValid = true;
        HashSet ids = Sets.newHashSet();
        for (ConfigurationItem configurationItem : deployeds) {
            if (!ids.add(configurationItem.getId())) {
                ValidationMessage msg = new ValidationMessage(configurationItem.getId(), "name", String.format("The deployed [%s] must have a unique name within the container [%s]", configurationItem, ((EmbeddedDeployedContainer)configurationItem).getContainer()));
                configurationItem.get$validationMessages().add(msg);
                validated.add(configurationItem);
                deployedsValid = false;
                continue;
            }
            validated.add(configurationItem);
        }
        return deployedsValid;
    }

    private ConfigurationItem validateDeployedApplication(ConfigurationItem deployedApplicationEntity) {
        List messages = this.validator.validate(deployedApplicationEntity, Collections.emptyList());
        Iterable filteredMessages = Iterables.filter((Iterable)messages, input -> !"deployeds".equals(input.getPropertyName()));
        if (Iterables.size((Iterable)filteredMessages) > 0) {
            deployedApplicationEntity.get$validationMessages().addAll(Lists.newArrayList((Iterable)filteredMessages));
        }
        return deployedApplicationEntity;
    }

    private void checkCiExists(String ciId) {
        if (!this.repositoryService.exists(ciId)) {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{ciId});
        }
    }

    private static /* synthetic */ void lambda$generateSelectedDeployeds$5(Map deployables, String id) {
        Checks.checkArgument((boolean)deployables.containsKey(id), (String)"All sources should be from same package or its dependencies.", (Object[])new Object[0]);
    }

    private static class PreviewCleaner
    implements RemovalListener<String, PreviewWithWorkdir<?>> {
        private PreviewCleaner() {
        }

        public void onRemoval(RemovalNotification<String, PreviewWithWorkdir<?>> notification) {
            if (notification.getValue() != null) {
                logger.info("Cleaning up Preview [{}] with workDir [{}]", notification.getKey(), (Object)((PreviewWithWorkdir)notification.getValue()).workDir);
                ((PreviewWithWorkdir)notification.getValue()).cleanUp();
            }
        }
    }

    private static final class TaskPreviewBlockBuilder
    implements PreviewBuilder<TaskPreviewBlock> {
        private TaskPreviewBlockBuilder() {
        }

        @Override
        public PreviewWithWorkdir<TaskPreviewBlock> build(String deploymentId, WorkDir workDir, TaskSpecification taskSpecification) {
            TaskPreviewBlock preview = new TaskPreviewBlock(deploymentId, (BlockState)taskSpecification.getBlock());
            return new PreviewWithWorkdir<TaskPreviewBlock>(preview, workDir);
        }

        public String toString() {
            return "task preview block";
        }
    }

    private static interface PreviewBuilder<T extends AbstractDto> {
        public PreviewWithWorkdir<T> build(String var1, WorkDir var2, TaskSpecification var3);
    }

    private static class PreviewWithWorkdir<T extends AbstractDto> {
        private final T preview;
        private final WorkDir workDir;

        private PreviewWithWorkdir(T preview, WorkDir workDir) {
            this.preview = preview;
            this.workDir = workDir;
        }

        void cleanUp() {
            this.workDir.delete();
        }

        public T getPreview() {
            return this.preview;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.workDir.delete();
        }
    }
}

