/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.settings.GeneralSettings;
import ai.digital.deploy.sql.model.CreatePersonalAccessTokenForm;
import ai.digital.deploy.sql.model.UserTokensView;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.XldUserTokenService;
import com.xebialabs.deployit.core.rest.api.AbstractUserRestrictedResource;
import com.xebialabs.deployit.core.rest.api.XldUserTokenService$;
import com.xebialabs.deployit.core.service.GeneralSettingsService;
import com.xebialabs.deployit.core.util.TokenGenerator$;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.principaldata.PrincipalDataProvider;
import com.xebialabs.deployit.security.principaldata.UserData;
import com.xebialabs.deployit.security.service.UserTokenService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\u0007\u000e\u0001iA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002&\u0001!\t%a\n\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J!9\u0011Q\n\u0001\u0005B\u0005=#a\u0006-mIV\u001bXM\u001d+pW\u0016t7+\u001a:wS\u000e,\u0017*\u001c9m\u0015\tqq\"A\u0002ba&T!\u0001E\t\u0002\tI,7\u000f\u001e\u0006\u0003%M\tAaY8sK*\u0011A#F\u0001\tI\u0016\u0004Hn\\=ji*\u0011acF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0004\u0001my\u0002C\u0001\u000f\u001e\u001b\u0005i\u0011B\u0001\u0010\u000e\u0005y\t%m\u001d;sC\u000e$Xk]3s%\u0016\u001cHO]5di\u0016$'+Z:pkJ\u001cW\r\u0005\u0002!E5\t\u0011E\u0003\u0002\u000f#%\u00111%\t\u0002\u001412$Wk]3s)>\\WM\\*feZL7-Z\u0001\u0011kN,'\u000fV8lK:\u001cVM\u001d<jG\u0016\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u000fM,'O^5dK*\u0011!fE\u0001\tg\u0016\u001cWO]5us&\u0011Af\n\u0002\u0011+N,'\u000fV8lK:\u001cVM\u001d<jG\u0016\f1\"^:feN+'O^5dKB\u0011q\u0006M\u0007\u0002S%\u0011\u0011'\u000b\u0002\f+N,'oU3sm&\u001cW-A\u000bqe&t7-\u001b9bY\u0012\u000bG/\u0019)s_ZLG-\u001a:\u0011\u0005Q:T\"A\u001b\u000b\u0005YJ\u0013!\u00049sS:\u001c\u0017\u000e]1mI\u0006$\u0018-\u0003\u00029k\t)\u0002K]5oG&\u0004\u0018\r\u001c#bi\u0006\u0004&o\u001c<jI\u0016\u0014\u0018AF4f]\u0016\u0014\u0018\r\\*fiRLgnZ:TKJ4\u0018nY3\u0011\u0005mjT\"\u0001\u001f\u000b\u0005!\n\u0012B\u0001 =\u0005Y9UM\\3sC2\u001cV\r\u001e;j]\u001e\u001c8+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0003B\u0005\u000e#U\t\u0005\u0002\u001d\u0001!)A%\u0002a\u0001K!)Q&\u0002a\u0001]!)!'\u0002a\u0001g!)\u0011(\u0002a\u0001u!\u0012Qa\u0012\t\u0003\u0011Nk\u0011!\u0013\u0006\u0003\u0015.\u000b!\"\u00198o_R\fG/[8o\u0015\taU*A\u0004gC\u000e$xN]=\u000b\u00059{\u0015!\u00022fC:\u001c(B\u0001)R\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001*\u0002\u0007=\u0014x-\u0003\u0002U\u0013\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u000eO\u0016$Xk]3s)>\\WM\\:\u0015\t]+\u0007/\u001e\t\u00031\u000el\u0011!\u0017\u0006\u00035n\u000bQ!\\8eK2T!\u0001X/\u0002\u0007M\fHN\u0003\u0002_?\u00061A-\u001a9m_fT!\u0001Y1\u0002\u000f\u0011Lw-\u001b;bY*\t!-\u0001\u0002bS&\u0011A-\u0017\u0002\u000f+N,'\u000fV8lK:\u001ch+[3x\u0011\u00151g\u00011\u0001h\u0003\u0019\u0001\u0018mZ5oOB\u0011\u0001N\\\u0007\u0002S*\u0011!n[\u0001\u0004IR|'B\u0001\bm\u0015\ti7#\u0001\u0004f]\u001eLg.Z\u0005\u0003_&\u0014a\u0001U1hS:<\u0007\"B9\u0007\u0001\u0004\u0011\u0018!B8sI\u0016\u0014\bC\u00015t\u0013\t!\u0018N\u0001\u0005Pe\u0012,'/\u001b8h\u0011\u00151h\u00011\u0001x\u0003%!xn[3o\u001d>$X\rE\u0002y\u0003\u0007q!!_@\u0011\u0005ilX\"A>\u000b\u0005qL\u0012A\u0002\u001fs_>$hHC\u0001\u007f\u0003\u0015\u00198-\u00197b\u0013\r\t\t!`\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005Q0\u0001\u000bhKR$vn[3og\u001a{'/V:fe:\fW.\u001a\u000b\n/\u00065\u0011\u0011CA\n\u0003+Aa!a\u0004\b\u0001\u00049\u0018\u0001C;tKJt\u0017-\\3\t\u000b\u0019<\u0001\u0019A4\t\u000bE<\u0001\u0019\u0001:\t\u000bY<\u0001\u0019A<\u0002#\u001d,g.\u001a:bi\u0016,6/\u001a:U_.,g\u000eF\u0002X\u00037Aq!!\b\t\u0001\u0004\ty\"A\u0007vg\u0016\u0014Hk\\6f]\u001a{'/\u001c\t\u00041\u0006\u0005\u0012bAA\u00123\ni2I]3bi\u0016\u0004VM]:p]\u0006d\u0017iY2fgN$vn[3o\r>\u0014X.\u0001\u0011eK2,G/Z+tKJ$vn[3o\u0005f,6/\u001a:oC6,\u0017I\u001c3DS&#GCBA\u0015\u0003c\t\u0019\u0004\u0005\u0003\u0002,\u00055R\"A?\n\u0007\u0005=RP\u0001\u0003V]&$\bBBA\b\u0013\u0001\u0007q\u000fC\u0004\u00026%\u0001\r!a\u000e\u0002\t\rL\u0017\n\u001a\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0013\u0001\u00026bm\u0006LA!!\u0012\u0002<\t9\u0011J\u001c;fO\u0016\u0014\u0018!\u00063fY\u0016$X-V:feR{7.\u001a8Cs\u000eK\u0017\n\u001a\u000b\u0005\u0003S\tY\u0005C\u0004\u00026)\u0001\r!a\u000e\u0002'\u001d,G/V:fe:\fW.\u001a$peR{7.\u001a8\u0015\u0007]\f\t\u0006\u0003\u0004\u0002T-\u0001\ra^\u0001\u0006i>\\WM\u001c\u0015\u0004\u0001\u0005]\u0003\u0003BA-\u0003?j!!a\u0017\u000b\u0007\u0005us*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!\u0019\u0002\\\tQ1i\u001c8ue>dG.\u001a:")
public class XldUserTokenServiceImpl
extends AbstractUserRestrictedResource
implements XldUserTokenService {
    private final UserTokenService userTokenService;
    private final UserService userService;
    private final PrincipalDataProvider principalDataProvider;
    private final GeneralSettingsService generalSettingsService;

    public UserTokensView getUserTokens(Paging paging, Ordering order, String tokenNote) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        XldUserToken userTokens = this.userTokenService.listUserTokenByUserName(authentication.getName(), paging, order, tokenNote);
        if (userTokens == null) {
            return new UserTokensView(authentication.getName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        }
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenView((Tokens)tokens))).asJava());
    }

    public UserTokensView getTokensForUsername(String username, Paging paging, Ordering order, String tokenNote) {
        this.checkCurrentUserOrPermissions(username, (scala.collection.immutable.Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{PlatformPermissions.ADMIN}));
        XldUserToken userTokens = this.userTokenService.listUserTokenByUserName(username, paging, order, tokenNote);
        if (userTokens == null) {
            return new UserTokensView(username, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        }
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenView((Tokens)tokens))).asJava());
    }

    public UserTokensView generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        boolean personalAccessTokenSupported;
        boolean bl;
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        UserData userData = this.principalDataProvider.getUserData(username);
        try {
            this.userService.read(username);
            bl = true;
        }
        catch (NotFoundException notFoundException) {
            bl = false;
        }
        boolean user = bl;
        GeneralSettings generalSettings = this.generalSettingsService.getGeneralSettings();
        boolean bl2 = personalAccessTokenSupported = generalSettings.patEnableForSSO() || userData.isFound() || user;
        if (!personalAccessTokenSupported) {
            throw new Checks.IncorrectArgumentException("Personal access tokens are only supported for internal users and external users authenticated via LDAP", new Object[0]);
        }
        Checks.checkArgument((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(userTokenForm.tokenNote())), (String)"Note can't be blank", (Object[])new Object[0]);
        boolean isValidExpiryDate = userTokenForm.expiryDate() != null ? userTokenForm.expiryDate().getTime() > System.currentTimeMillis() : true;
        Checks.checkArgument((boolean)isValidExpiryDate, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.tokenNote().trim();
        userTokenForm.tokenNote_$eq(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        XldUserToken xldUserToken = this.userTokenService.listUserTokenByUserName(username, null, null, null);
        Checks.checkArgument((!xldUserToken.tokens().exists((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)XldUserTokenServiceImpl.$anonfun$generateUserToken$1(userTokenForm, token))) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
        XldUserToken userTokens = this.userTokenService.createUserToken(username, userTokenForm.tokenNote(), userTokenForm.expiryDate());
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenViewForCreateToken((Tokens)tokens))).asJava());
    }

    public void deleteUserTokenByUsernameAndCiId(String username, Integer ciId) {
        this.checkCurrentUserOrPermissions(username, (scala.collection.immutable.Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{PlatformPermissions.ADMIN}));
        this.userTokenService.deleteUserToken(username, ciId);
    }

    public void deleteUserTokenByCiId(Integer ciId) {
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        XldUserToken xldUserToken = this.userTokenService.listUserTokenByUserName(username, null, null, null);
        if (xldUserToken.tokens().exists((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)XldUserTokenServiceImpl.$anonfun$deleteUserTokenByCiId$1(ciId, token)))) {
            this.userTokenService.deleteUserToken(username, ciId);
            return;
        }
        throw new Checks.IncorrectArgumentException("Personal access token ciId[" + ciId + "] does not belong to user[" + username + "]", new Object[0]);
    }

    public String getUsernameForToken(String token) {
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        XldUserToken userToken = this.userTokenService.findByUserToken(tokenHash);
        XldUserToken xldUserToken = userToken;
        if (xldUserToken == null) {
            throw new NotFoundException("Token not found: " + token, new Object[0]);
        }
        return userToken.username();
    }

    public static final /* synthetic */ boolean $anonfun$generateUserToken$1(CreatePersonalAccessTokenForm userTokenForm$1, Tokens token) {
        String string = token.tokenNote();
        String string2 = userTokenForm$1.tokenNote();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteUserTokenByCiId$1(Integer ciId$1, Tokens token) {
        Integer n = token.ciId();
        Integer n2 = ciId$1;
        return !(n != null ? !((Object)n).equals(n2) : n2 != null);
    }

    @Autowired
    public XldUserTokenServiceImpl(UserTokenService userTokenService, UserService userService, PrincipalDataProvider principalDataProvider, GeneralSettingsService generalSettingsService) {
        this.userTokenService = userTokenService;
        this.userService = userService;
        this.principalDataProvider = principalDataProvider;
        this.generalSettingsService = generalSettingsService;
    }
}

