package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import org.joda.time.DateTime;

import java.util.List;
import java.util.Map;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

public class TaskStateView implements TaskState {
    private TaskState wrapped;

    public TaskStateView(SerializableTask wrapped) {
        checkArgument(wrapped instanceof TaskState, "Should be a TaskState, but was a %s", wrapped.getClass());
        this.wrapped = (TaskState) wrapped;
    }

    @Override
    public TaskExecutionState getState() {
        return wrapped.getState();
    }

    @Override
    public String getId() {
        return wrapped.getId();
    }

    @Override
    public String getDescription() {
        return wrapped.getDescription();
    }

    @Override
    public DateTime getScheduledDate() {
        return wrapped.getScheduledDate();
    }

    @Override
    public DateTime getStartDate() {
        return wrapped.getStartDate();
    }

    @Override
    public DateTime getCompletionDate() {
        return wrapped.getCompletionDate();
    }

    @Override
    public int getNrSteps() {
        return wrapped.getNrSteps();
    }

    @Override
    public int getCurrentStepNr() {
        return wrapped.getCurrentStepNr();
    }

    @Override
    public List<Integer> getCurrentStepNrs() {
        return wrapped.getCurrentStepNrs();
    }

    @Override
    public Map<String, String> getMetadata() {
        return wrapped.getMetadata();
    }

    @Override
    public int getFailureCount() {
        return wrapped.getFailureCount();
    }

    @Override
    public String getOwner() {
        return wrapped.getOwner();
    }

    @Override
    public Integer getWorkerId() {
        return wrapped.getWorkerId();
    }

    @Override
    public List<TaskPackageDependency> getPackageDependencies() {
        return wrapped.getPackageDependencies();
    }
}
