/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.service.impl;

import ai.digital.deploy.settings.GeneralSettings;
import ai.digital.deploy.settings.GeneralSettings$;
import ai.digital.deploy.sql.model.ConfigurationDto;
import ai.digital.deploy.sql.model.ConfigurationDto$;
import com.xebialabs.deployit.core.service.GeneralSettingsService;
import com.xebialabs.deployit.core.util.GeneralSettingsUtils$;
import com.xebialabs.deployit.repository.ConfigurationRepository;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\f\u0018\u0001\u0011B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006\u000b\u0002!\tA\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019)\u0006\u0001)A\u0005\u001b\"9a\u000b\u0001b\u0001\n\u0013a\u0005BB,\u0001A\u0003%Q\nC\u0004Y\u0001\t\u0007I\u0011\u0002'\t\re\u0003\u0001\u0015!\u0003N\u0011\u001dQ\u0006A1A\u0005\n1Caa\u0017\u0001!\u0002\u0013i\u0005b\u0002/\u0001\u0005\u0004%I\u0001\u0014\u0005\u0007;\u0002\u0001\u000b\u0011B'\t\u000fy\u0003!\u0019!C\u0005\u0019\"1q\f\u0001Q\u0001\n5Cq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004k\u0001\u0001\u0006IA\u0019\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006s\u0002!\tE\u001f\u0005\u0006{\u0002!IA \u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003K\u0011!dR3oKJ\fGnU3ui&twm]*feZL7-Z%na2T!\u0001G\r\u0002\t%l\u0007\u000f\u001c\u0006\u00035m\tqa]3sm&\u001cWM\u0003\u0002\u001d;\u0005!1m\u001c:f\u0015\tqr$\u0001\u0005eKBdw._5u\u0015\t\u0001\u0013%A\u0005yK\nL\u0017\r\\1cg*\t!%A\u0002d_6\u001c\u0001aE\u0002\u0001K-\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u0017.\u001b\u0005I\u0012B\u0001\u0018\u001a\u0005Y9UM\\3sC2\u001cV\r\u001e;j]\u001e\u001c8+\u001a:wS\u000e,\u0017aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\t\tD'D\u00013\u0015\t\u0019T$\u0001\u0006sKB|7/\u001b;pefL!!\u000e\u001a\u0003/\r{gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bFA\u00018!\tA4)D\u0001:\u0015\tQ4(\u0001\u0006b]:|G/\u0019;j_:T!\u0001P\u001f\u0002\u000f\u0019\f7\r^8ss*\u0011ahP\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u0001\u0006\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011K$!C!vi><\u0018N]3e\u0003\u0019a\u0014N\\5u}Q\u0011q)\u0013\t\u0003\u0011\u0002i\u0011a\u0006\u0005\u0006_\t\u0001\r\u0001\r\u0015\u0003\u0013^\nA\u0002S#B\t\u0016\u0013vlQ(M\u001fJ+\u0012!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001\\1oO*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005\u0019\u0019FO]5oO\u0006i\u0001*R!E\u000bJ{6i\u0014'P%\u0002\nQ\"\u0013(T)\u0006s5)R0O\u00036+\u0015AD%O'R\u000bejQ#`\u001d\u0006kU\tI\u0001\u0015\u0019>;\u0015JT0T\u0007J+UIT0N\u000bN\u001b\u0016iR#\u0002+1{u)\u0013(`'\u000e\u0013V)\u0012(`\u001b\u0016\u001b6+Q$FA\u0005IAjT$P?\u001aKE*R\u0001\u000b\u0019>;uj\u0018$J\u0019\u0016\u0003\u0013A\u0005)B)~+e*\u0011\"M\u000b~3uJU0T'>\u000b1\u0003U!U?\u0016s\u0015I\u0011'F?\u001a{%kX*T\u001f\u0002\nq\u0003U!U?\u0016C\u0006+\u0013*B)&{ej\u0018#V%\u0006#\u0016j\u0014(\u00021A\u000bEkX#Y!&\u0013\u0016\tV%P\u001d~#UKU!U\u0013>s\u0005%A\u0006tm\u001e\u001c\u0016MZ3MSN$X#\u00012\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017AB:bM\u0016$\u0018P\u0003\u0002h\u0003\u0006)!n]8va&\u0011\u0011\u000e\u001a\u0002\t'\u00064W\r\\5ti\u0006a1O^4TC\u001a,G*[:uA\u0005\u0011r-\u001a;HK:,'/\u00197TKR$\u0018N\\4t+\u0005i\u0007C\u00018x\u001b\u0005y'B\u00019r\u0003!\u0019X\r\u001e;j]\u001e\u001c(B\u0001:t\u0003\u0019!W\r\u001d7ps*\u0011A/^\u0001\bI&<\u0017\u000e^1m\u0015\u00051\u0018AA1j\u0013\tAxNA\bHK:,'/\u00197TKR$\u0018N\\4t\u0003U)\b\u000fZ1uK\u001e+g.\u001a:bYN+G\u000f^5oON$\"!\\>\t\u000bq\u0014\u0002\u0019A7\u0002\u001f\u001d,g.\u001a:bYN+G\u000f^5oON\f\u0001c]1oSRL'0\u001a'pO>4\u0015\u000e\\3\u0015\u000b}\f\u0019\"a\u0006\u0011\t\u0005\u0005\u0011q\u0002\b\u0005\u0003\u0007\tY\u0001E\u0002\u0002\u0006\u001dj!!a\u0002\u000b\u0007\u0005%1%\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001b9\u0013A\u0002)sK\u0012,g-C\u0002U\u0003#Q1!!\u0004(\u0011\u0019\t)b\u0005a\u0001\u007f\u0006Y1m\u001c8uK:$H+\u001f9f\u0011\u0019\tIb\u0005a\u0001\u007f\u0006AAn\\4p\r&dW-A\u0006tC:LG/\u001b>f'Z<GcA@\u0002 !1\u0011\u0011\u0005\u000bA\u0002}\f!b\u001d<h\u0007>tG/\u001a8u\u00031\u0019\u0018M\\5uSj,\u0007\n^7m)\ry\u0018q\u0005\u0005\u0007\u0003S)\u0002\u0019A@\u0002\t!$X\u000e\u001c\u0015\u0004\u0001\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005Mr(\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u000e\u00022\t91+\u001a:wS\u000e,\u0007")
public class GeneralSettingsServiceImpl
implements GeneralSettingsService {
    @Autowired
    private final ConfigurationRepository configurationRepository;
    private final String HEADER_COLOR;
    private final String INSTANCE_NAME;
    private final String LOGIN_SCREEN_MESSAGE;
    private final String LOGO_FILE;
    private final String PAT_ENABLE_FOR_SSO;
    private final String PAT_EXPIRATION_DURATION;
    private final Safelist svgSafeList;

    private String HEADER_COLOR() {
        return this.HEADER_COLOR;
    }

    private String INSTANCE_NAME() {
        return this.INSTANCE_NAME;
    }

    private String LOGIN_SCREEN_MESSAGE() {
        return this.LOGIN_SCREEN_MESSAGE;
    }

    private String LOGO_FILE() {
        return this.LOGO_FILE;
    }

    private String PAT_ENABLE_FOR_SSO() {
        return this.PAT_ENABLE_FOR_SSO;
    }

    private String PAT_EXPIRATION_DURATION() {
        return this.PAT_EXPIRATION_DURATION;
    }

    private Safelist svgSafeList() {
        return this.svgSafeList;
    }

    @Override
    public GeneralSettings getGeneralSettings() {
        ObjectRef headerColor = ObjectRef.create((Object)"");
        ObjectRef instanceName = ObjectRef.create((Object)"");
        ObjectRef loginScreenMessage = ObjectRef.create((Object)"");
        ObjectRef logoFile = ObjectRef.create((Object)"");
        BooleanRef patEnableForSSO = BooleanRef.create((boolean)false);
        ObjectRef patExpirationDuration = ObjectRef.create((Object)"");
        List configurationList = this.configurationRepository.getConfigurationByKey();
        configurationList.foreach((Function1 & Serializable)x0$1 -> {
            GeneralSettingsServiceImpl.$anonfun$getGeneralSettings$1(this, headerColor, instanceName, loginScreenMessage, logoFile, patEnableForSSO, patExpirationDuration, x0$1);
            return BoxedUnit.UNIT;
        });
        return GeneralSettings$.MODULE$.apply((String)headerColor.elem, (String)instanceName.elem, (String)loginScreenMessage.elem, (String)logoFile.elem, patEnableForSSO.elem, (String)patExpirationDuration.elem);
    }

    @Override
    public GeneralSettings updateGeneralSettings(GeneralSettings generalSettings) {
        GeneralSettings generalSettings2;
        if (generalSettings.logoFile() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(generalSettings.logoFile()))) {
            String sanitizedLogoFile;
            String logoMimeType = GeneralSettingsUtils$.MODULE$.getLogoMimeType(generalSettings.logoFile());
            String x$1 = sanitizedLogoFile = this.sanitizeLogoFile(logoMimeType, generalSettings.logoFile());
            String x$2 = generalSettings.copy$default$1();
            String x$3 = generalSettings.copy$default$2();
            String x$4 = generalSettings.copy$default$3();
            boolean x$5 = generalSettings.copy$default$5();
            String x$6 = generalSettings.copy$default$6();
            generalSettings2 = generalSettings.copy(x$2, x$3, x$4, x$1, x$5, x$6);
        } else {
            generalSettings2 = generalSettings;
        }
        GeneralSettings sanitizedGeneralSettings = generalSettings2;
        Set keysList = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.HEADER_COLOR(), this.INSTANCE_NAME(), this.LOGIN_SCREEN_MESSAGE(), this.LOGO_FILE(), this.PAT_ENABLE_FOR_SSO(), this.PAT_EXPIRATION_DURATION()}));
        keysList.foreach((Function1 & Serializable)key -> {
            GeneralSettingsServiceImpl.$anonfun$updateGeneralSettings$1(this, generalSettings, sanitizedGeneralSettings, key);
            return BoxedUnit.UNIT;
        });
        return this.getGeneralSettings();
    }

    private String sanitizeLogoFile(String contentType, String logoFile) {
        Object object;
        String string = contentType;
        String string2 = "image/svg+xml";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            int base64Index = logoFile.indexOf("base64,") + "base64,".length();
            String base64Content = logoFile.substring(base64Index);
            byte[] decodedBytes = Base64.getDecoder().decode(base64Content);
            String imageContent = this.sanitizeSvg(new String(decodedBytes, StandardCharsets.UTF_8));
            byte[] sanitizedBytes = imageContent.getBytes(StandardCharsets.UTF_8);
            String sanitizedBase64Content = Base64.getEncoder().encodeToString(sanitizedBytes);
            object = logoFile.substring(0, base64Index) + sanitizedBase64Content;
        } else {
            object = logoFile;
        }
        String sanitizedContent = object;
        return sanitizedContent;
    }

    private String sanitizeSvg(String svgContent) {
        return Jsoup.clean((String)svgContent, (String)"", (Safelist)this.svgSafeList(), (Document.OutputSettings)new Document.OutputSettings().prettyPrint(false));
    }

    private String sanitizeHtml(String html) {
        return Jsoup.clean((String)html, (Safelist)Safelist.basic());
    }

    public static final /* synthetic */ void $anonfun$getGeneralSettings$1(GeneralSettingsServiceImpl $this, ObjectRef headerColor$1, ObjectRef instanceName$1, ObjectRef loginScreenMessage$1, ObjectRef logoFile$1, BooleanRef patEnableForSSO$1, ObjectRef patExpirationDuration$1, ConfigurationDto x0$1) {
        ConfigurationDto configurationDto = x0$1;
        if (configurationDto.key().endsWith($this.HEADER_COLOR())) {
            headerColor$1.elem = configurationDto.value();
            return;
        }
        if (configurationDto.key().endsWith($this.INSTANCE_NAME())) {
            instanceName$1.elem = configurationDto.value();
            return;
        }
        if (configurationDto.key().endsWith($this.LOGIN_SCREEN_MESSAGE())) {
            loginScreenMessage$1.elem = configurationDto.value();
            return;
        }
        if (configurationDto.key().endsWith($this.LOGO_FILE())) {
            logoFile$1.elem = configurationDto.value();
            return;
        }
        if (configurationDto.key().endsWith($this.PAT_ENABLE_FOR_SSO())) {
            patEnableForSSO$1.elem = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(configurationDto.value()));
            return;
        }
        if (configurationDto.key().endsWith($this.PAT_EXPIRATION_DURATION())) {
            patExpirationDuration$1.elem = configurationDto.value();
            return;
        }
        throw new MatchError((Object)configurationDto);
    }

    public static final /* synthetic */ void $anonfun$updateGeneralSettings$1(GeneralSettingsServiceImpl $this, GeneralSettings generalSettings$1, GeneralSettings sanitizedGeneralSettings$1, String key) {
        String value = "";
        String string = key;
        String string2 = $this.HEADER_COLOR();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            value = generalSettings$1.headerColor();
        } else {
            String string4 = $this.INSTANCE_NAME();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                value = generalSettings$1.instanceName();
            } else {
                String string6 = $this.LOGIN_SCREEN_MESSAGE();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    value = $this.sanitizeHtml(generalSettings$1.loginScreenMessage());
                } else {
                    String string8 = $this.LOGO_FILE();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        value = sanitizedGeneralSettings$1.logoFile();
                    } else {
                        String string10 = $this.PAT_ENABLE_FOR_SSO();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            value = Boolean.toString(generalSettings$1.patEnableForSSO());
                        } else {
                            String string12 = $this.PAT_EXPIRATION_DURATION();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                value = generalSettings$1.patExpirationDuration();
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        $this.configurationRepository.saveOrUpdate(ConfigurationDto$.MODULE$.apply(key.replace("_", " "), key, value));
    }

    public GeneralSettingsServiceImpl(@Autowired ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
        this.HEADER_COLOR = "header_color";
        this.INSTANCE_NAME = "instance_name";
        this.LOGIN_SCREEN_MESSAGE = "login_screen_message";
        this.LOGO_FILE = "logo_file";
        this.PAT_ENABLE_FOR_SSO = "pat_enable_for_sso";
        this.PAT_EXPIRATION_DURATION = "pat_expiration_duration";
        this.svgSafeList = Safelist.basic().addTags(new String[]{"svg", "g", "path", "rect", "circle", "ellipse", "line", "polyline", "polygon", "text", "tspan"}).addAttributes(":all", new String[]{"style", "fill", "fill-rule", "clip-rule", "stroke", "d", "width", "height", "viewBox", "x", "y", "r", "cx", "cy", "points", "transform", "xmlns"}).addProtocols("xlink:href", "http", new String[]{"https"});
    }
}

