/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import ai.digital.deploy.tasker.common.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks;
import com.xebialabs.xltype.serialization.util.DateUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DeploymentsForEnvironmentReport {
    private final TaskArchive taskArchive;

    public DeploymentsForEnvironmentReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(String environment, DateTime before) {
        Stream tasks = this.taskArchive.lastDeploymentsOnEnvironment(environment, before, 2);
        Map tasksByApplication = tasks.collect(Collectors.groupingBy(map -> (String)map.get(ArchivedDeploymentTasks.main_application().name()), DeploymentsForEnvironmentReport.toSortedList((lhs, rhs) -> {
            DateTime lhsDate = (DateTime)lhs.get(ArchivedDeploymentTasks.end_date().name());
            DateTime rhsDate = (DateTime)rhs.get(ArchivedDeploymentTasks.end_date().name());
            return lhsDate.compareTo((ReadableInstant)rhsDate);
        })));
        return Report.fromLines(tasksByApplication.values().stream().map(this::fillDeployedAppsInReport).filter(Objects::nonNull));
    }

    private ReportLine fillDeployedAppsInReport(List<Map<String, Object>> taskList) {
        Map<String, Object> deployedApp = null;
        Map<String, Object> latestTask = taskList.get(taskList.size() - 1);
        String task_type = (String)latestTask.get(ArchivedDeploymentTasks.task_type().name());
        String version = null;
        if (task_type.equals(TaskType.INITIAL.name()) || task_type.equals(TaskType.UPGRADE.name())) {
            deployedApp = latestTask;
            version = this.version(deployedApp);
        }
        if (task_type.equals(TaskType.ROLLBACK.name()) && taskList.get(0).get(ArchivedDeploymentTasks.task_type().name()).equals(TaskType.UPGRADE.name())) {
            deployedApp = taskList.get(0);
            version = this.version(latestTask);
        }
        if (deployedApp != null) {
            ReportLine line = new ReportLine();
            line.addValue("application", deployedApp.get(ArchivedDeploymentTasks.main_application().name()));
            line.addValue("taskId", deployedApp.get(ArchivedDeploymentTasks.task_id().name()));
            line.addValue("version", (Object)version);
            line.addValue("user", deployedApp.get(ArchivedDeploymentTasks.owner().name()));
            line.addValue("date", (Object)DateUtil.toString((DateTime)((DateTime)deployedApp.get(ArchivedDeploymentTasks.end_date().name()))));
            return line;
        }
        return null;
    }

    private String version(Map<String, Object> deployedApp) {
        return ((String)deployedApp.get(ArchivedDeploymentTasks.packages().name())).split("/")[1];
    }

    private static <T> Collector<T, ?, List<T>> toSortedList(Comparator<? super T> c) {
        return Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), l -> {
            l.sort(c);
            return l;
        });
    }
}

