package com.xebialabs.deployit.core.service.status

import com.xebialabs.deployit.core.events.dto.{ApplicationDeploymentPackageState, DeployedApplicationPackage}
import grizzled.slf4j.Logging
import org.apache.commons.lang3.exception.ExceptionUtils
import org.springframework.jms.annotation.JmsListener
import org.springframework.jms.support.converter.MessageConverter
import org.springframework.stereotype.Component
import jakarta.jms.TextMessage

@Component
class DeploymentPackageStatusConsumer(
                                       jacksonJmsMessageConverter: MessageConverter,
                                       deploymentPackageStatusService: DeploymentPackageStatusService
                                     ) extends Logging {
  @JmsListener(
    destination = "#{@deploymentPackageStatusQueueNameResolver.getDeploymentPackageStatusQueueName()}",
    containerFactory = "xlJmsListenerContainerFactory"
  )
  def receiveTextMessage(message: TextMessage): Unit = {
    try {
      jacksonJmsMessageConverter.fromMessage(message) match {
        case event: DeployedApplicationPackage =>
          deploymentPackageStatusService.send(event)
        case stateChange: ApplicationDeploymentPackageState =>
          deploymentPackageStatusService.send(stateChange)
        case _ =>
          logger.error(s"Received unknown ${message.getJMSMessageID} timestamp: ${message.getJMSTimestamp} [$message]")
      }
    } catch {
      case e: Exception => logger.warn("Exception occurred in processing message for " +
        "DeploymentPackageStatusConsumer Listener , message - ", message.getText, "with stacktrace", ExceptionUtils.getStackTrace(e))
    }
  }
}
