package com.xebialabs.deployit.core.rest.api

import java.util
import java.util.stream

import ai.digital.deploy.sql.http.enricher.PaginationService
import com.xebialabs.deployit.core.api.TaskMonitorService
import com.xebialabs.deployit.core.api.resteasy.Date
import com.xebialabs.deployit.core.service.TasksService
import com.xebialabs.deployit.core.service.TasksService.TaskSearchParameters
import com.xebialabs.deployit.engine.api.dto
import com.xebialabs.deployit.engine.api.dto.{ConfigurationItemId, Paging}
import com.xebialabs.deployit.engine.api.execution.{FetchMode, TaskSet, TaskWithBlock}
import com.xebialabs.deployit.security.Permissions
import jakarta.ws.rs.core.Context
import org.jboss.resteasy.spi.HttpResponse
import org.springframework.stereotype.Controller

import scala.jdk.CollectionConverters._
import scala.jdk.StreamConverters._

@Controller
class TaskMonitorServiceImpl(tasksService: TasksService, paginationService: PaginationService) extends TaskMonitorService {
  @Context private var response: HttpResponse = _

  override def getControlTasks(begin: Date,
                               end: Date,
                               states: util.List[String],
                               users: util.List[String],
                               taskName: String,
                               taskId: String,
                               fetchMode: FetchMode,
                               taskSet: TaskSet,
                               paging: Paging,
                               order: util.List[dto.Ordering],
                               workerName: String,
                               targets: util.List[String]): stream.Stream[TaskWithBlock] =
    tasksService.streamControlTasks(
      TaskSearchParameters(
        begin = begin.asDateTime(),
        end = end.asDateTime(),
        states = states.asScala.toList,
        users = users.asScala.toList,
        taskName = Option(taskName),
        taskId = Option(taskId),
        fetchMode = fetchMode,
        taskSet = taskSet,
        paging = Option(paging),
        order = order.asScala.toList,
        setTotalCount = paginationService.toSetHeader(response),
        workerName = Option(workerName),
        targets = targets.asScala.toList
      ),
      Permissions.getAuthenticatedUserName
    ).asJava.stream()

  override def getDeploymentTasks(begin: Date,
                                  end: Date,
                                  states: util.List[String],
                                  users: util.List[String],
                                  taskTypes: util.List[String],
                                  taskId: String,
                                  fetchMode: FetchMode,
                                  taskSet: TaskSet,
                                  onlySuccessful: Boolean,
                                  paging: Paging, order: util.List[dto.Ordering],
                                  workerName: String,
                                  configurationItemIds: util.List[ConfigurationItemId]): stream.Stream[TaskWithBlock] = {
    tasksService.streamDeploymentTasks(
      TaskSearchParameters(
        begin = begin.asDateTime(),
        end = end.asDateTime(),
        states = states.asScala.toList,
        users = users.asScala.toList,
        taskName = None,
        taskId = Option(taskId),
        fetchMode = fetchMode,
        taskSet = taskSet,
        paging = Option(paging),
        order = order.asScala.toList,
        taskTypes = taskTypes.asScala.toList,
        onlySuccessful = onlySuccessful,
        setTotalCount = paginationService.toSetHeader(response),
        workerName = Option(workerName),
        configurationItemIds = configurationItemIds.asScala.toList),
      Permissions.getAuthenticatedUserName
    ).asJavaSeqStream
  }
}
