/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.xml;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.converters.Converter;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.xml.XStreamCiConverterWithRepository;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/*+xml", "text/*+xml"})
@Consumes(value={"application/*+xml", "text/*+xml"})
public class SpringXStreamReaderWriter
extends XStreamReaderWriter
implements ApplicationContextAware {
    private static final List<String> blacklistPackages = Lists.newArrayList((Object[])new String[]{"com.xebialabs.deployit.booter.remote.xml", "com.xebialabs.deployit.taskexecution.xml"});
    private ApplicationContext applicationContext;

    @PostConstruct
    protected void init() {
        if (this.applicationContext != null) {
            super.init();
            XStreamReaderWriter.registerConfigurationItemAliases();
        }
    }

    protected Converter constructConverter(Class<?> clazz) {
        if (blacklistPackages.contains(clazz.getPackage().getName())) {
            return null;
        }
        try {
            Object bean = this.applicationContext.getBean(clazz);
            Checks.checkState((boolean)(bean instanceof Converter), (String)"[%s] should be a Converter", (Object[])new Object[]{bean});
            return (Converter)bean;
        }
        catch (BeansException be) {
            return super.constructConverter(clazz);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            Object object = super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
            return object;
        }
        catch (RuntimeException e) {
            XStreamCiConverterWithRepository.clear();
            throw e;
        }
        finally {
            XStreamCiConverterWithRepository.postProcess();
        }
    }
}

