package com.xebialabs.deployit.core.rest.json

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util

import ai.digital.deploy.sql.model.DefinedPlaceholderView
import com.xebialabs.xltype.serialization.json.JsonWriter
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyWriter, Provider}
import jakarta.ws.rs.{Produces, WebApplicationException}
import org.springframework.stereotype.Component

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class DefinedPlaceholderViewJsonWriter extends MessageBodyWriter[util.Collection[DefinedPlaceholderView]] {

  private val helper = new JsonWriterHelper

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[DefinedPlaceholderView].isAssignableFrom(helper.getType(`type`, genericType))

  override def getSize(viewList: util.Collection[DefinedPlaceholderView], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(viewList: util.Collection[DefinedPlaceholderView], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {
    val reportStreamWriter: OutputStreamWriter = new OutputStreamWriter(entityStream)
    writeJson(viewList, new JsonWriter(reportStreamWriter))
    reportStreamWriter.flush()
  }

  private def writeJson(viewList: util.Collection[DefinedPlaceholderView], writer: JsonWriter): Unit = {
    writer.array
    viewList.forEach(view => {
      writer.`object`()
      writer.key("key").value(view.getKey)
      writer.key("ciId").value(view.getCiId)
      writer.key("ciType").value(view.getCiType)
      writer.key("canRead").value(view.getCanRead)
      writer.endObject()
    })
    writer.endArray
  }
}
