package com.xebialabs.deployit.core.rest.xml

import com.thoughtworks.xstream.converters.{MarshallingContext, UnmarshallingContext}
import com.thoughtworks.xstream.io.{HierarchicalStreamReader, HierarchicalStreamWriter}
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine
import com.xebialabs.xltype.serialization.util.DateUtil
import com.xebialabs.xltype.serialization.xstream.{AbstractTaskWithBlockConverter, XStreamProvider}

@XStreamProvider(readable = classOf[ControlTaskReportLine], tagName = "controlTaskReportLine")
class ControlTaskReportLineWriter extends AbstractTaskWithBlockConverter {
  override def marshal(source: Any, writer: HierarchicalStreamWriter, context: MarshallingContext): Unit = {
    val line = source.asInstanceOf[ControlTaskReportLine]
    writer.addAttribute("owner", line.getOwner)
    writer.addAttribute("controlTaskTargetCI", line.getControlTaskTargetCI)
    writer.addAttribute("description", line.getDescription)
    writer.addAttribute("started", DateUtil.toString(line.getStarted))
    writer.addAttribute("finished", DateUtil.toString(line.getFinished))
    writer.addAttribute("taskName", line.getTaskName)
    writer.addAttribute("state", line.getState)
    writer.addAttribute("taskId", line.getTaskId)
    writer.addAttribute("worker_name", line.getWorkerName)
    Option(line.getBlock).foreach(writePhaseContainer(writer, context, _))
  }

  override def unmarshal(reader: HierarchicalStreamReader, context: UnmarshallingContext): AnyRef =
    throw new UnsupportedOperationException(s"Core will not deserialize ${classOf[ControlTaskReportLine].getName}")

  override def canConvert(`type`: Class[_]): Boolean = classOf[ControlTaskReportLine].isAssignableFrom(`type`)
}
