package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.IncludeStepBlocks;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.xltype.serialization.json.Converters;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.json.TaskWithBlockJsonConverter;
import org.springframework.stereotype.Component;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.stream.Stream;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class TaskWithBlockStepsJsonWriter implements MessageBodyWriter<TaskWithBlock> {

    static final TaskWithBlockJsonConverter taskWithBlockJsonConverter = new TaskWithBlockJsonConverter() {
        @Override
        protected void writeBlock(final BlockState task, final JsonWriter writer) {
            writer.key("block");
            Converters.writeBlockTree(task, writer, true);
        }
    };

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return TaskWithBlock.class.isAssignableFrom(type) && Stream.of(annotations).anyMatch(a -> a.annotationType().equals(IncludeStepBlocks.class));
    }

    @Override
    public long getSize(TaskWithBlock taskWithBlock, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1;
    }

    @Override
    public void writeTo(TaskWithBlock taskWithBlock, Class<?> type, Type genericType, Annotation[] annotations,
                        MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(taskWithBlock).getBytes());
    }

    @VisibleForTesting
    String toJson(TaskWithBlock taskWithBlock) {
        return taskWithBlockJsonConverter.toJson(taskWithBlock);
    }
}
