package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.engine.api.execution.BlockExecutionState;
import com.xebialabs.deployit.engine.api.execution.SatelliteConnectionState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class StepBlockStateView implements StepBlockState {

    private final StepBlockState wrapped;

    public StepBlockStateView(StepBlockState block) {
        this.wrapped = block;
    }

    @Override
    public int getCurrentStep() {
        return wrapped.getCurrentStep();
    }

    @Override
    public List<StepState> getSteps() {
        List<StepState> steps = wrapped.getSteps();
        return newArrayList(Iterables.transform(steps, (Function<StepState, StepState>) StepStateOptimised::new));
    }

    @Override
    public String getSatelliteId() {
        return wrapped.getSatelliteId();
    }

    @Override
    public String getId() {
        return wrapped.getId();
    }

    @Override
    public String getDescription() {
        return wrapped.getDescription();
    }

    @Override
    public BlockExecutionState getState() {
        return wrapped.getState();
    }

    @Override
    public SatelliteConnectionState getSatelliteConnectionState() {
        return wrapped.getSatelliteConnectionState();
    }

}
