package com.xebialabs.deployit.core.util

import java.lang.annotation.Annotation

import com.xebialabs.deployit.engine.api.LimitCiTreeDepth

object ReaderWriterUtils {
  /**
   * Tries to resolve maximum CI tree depth based on provided array of annotations
   * If @LimitCiTreeDepth annotation present, it's value will be used.
   * Otherwise, Int.MaxValue will be returned
   * @param annotations - array of input annotations
   * @return value from @LimitCiTreeDepth if present, Int.MaxValue otherwise
   */
  def getCiTreeDepth(annotations: Array[Annotation]): Int =
    annotations
      .collectFirst { case limit: LimitCiTreeDepth => limit.value() }
      .getOrElse(Int.MaxValue)
}
