/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.configuration.central.deploy.converter.HoconDurationConverter$;
import ai.digital.deploy.sql.model.WorkerInfo;
import com.xebialabs.deployit.core.api.WorkersService;
import com.xebialabs.deployit.core.rest.api.WorkerState$;
import com.xebialabs.deployit.core.rest.api.WorkersSorting$;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Worker;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.distribution.WorkerManager;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.spring.BeanWrapper;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Context;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.AddressFromURIString$;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001B\t\u0013\u0001}A\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t3\u0002\u0011\t\u0011)A\u00055\"A\u0001\r\u0001B\u0001B\u0003%A\r\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003n\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007A\u0011\"a\u0007\u0001\u0005\u0004%Y!!\b\t\u0011\u0005-\u0002\u0001)A\u0005\u0003?A\u0011\"!\f\u0001\u0005\u0004%\t!a\f\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003cAq!a\u0018\u0001\t\u0003\n\t\u0007C\u0004\u0002~\u0001!\t%a \t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBAW\u0001\u0011\u0005\u0013q\u0016\u0005\b\u0003g\u0003A\u0011IA[\u0011\u001d\t9\f\u0001C!\u0003s\u0013qbV8sW\u0016\u00148OU3t_V\u00148-\u001a\u0006\u0003'Q\t1!\u00199j\u0015\t)b#\u0001\u0003sKN$(BA\f\u0019\u0003\u0011\u0019wN]3\u000b\u0005eQ\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005ma\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0012aA2p[\u000e\u00011\u0003\u0002\u0001!M-\u0002\"!\t\u0013\u000e\u0003\tR!a\t\u000b\u0002\u000fM,7-\u001e:fI&\u0011QE\t\u0002\u0018\u0003\n\u001cHO]1diN+7-\u001e:fIJ+7o\\;sG\u0016\u0004\"aJ\u0015\u000e\u0003!R!a\u0005\f\n\u0005)B#AD,pe.,'o]*feZL7-\u001a\t\u0003YEj\u0011!\f\u0006\u0003]=\nQa\u001d7gi)T\u0011\u0001M\u0001\tOJL'P\u001f7fI&\u0011!'\f\u0002\b\u0019><w-\u001b8h\u000359xN]6fe6\u000bg.Y4feB\u0019Q\u0007\u000f\u001e\u000e\u0003YR!a\u000e\r\u0002\rM\u0004(/\u001b8h\u0013\tIdGA\u0006CK\u0006twK]1qa\u0016\u0014\bCA\u001eE\u001b\u0005a$BA\u001f?\u0003\u0015\t7\r^8s\u0015\ty\u0004)A\u0003qK.\\wN\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<\u0017BA#=\u0005!\t5\r^8s%\u00164\u0007FA\u0001H!\tA\u0015+D\u0001J\u0015\tQ5*\u0001\u0006b]:|G/\u0019;j_:T!\u0001T'\u0002\u000f\u0019\f7\r^8ss*\u0011ajT\u0001\u0006E\u0016\fgn\u001d\u0006\u0003!\n\u000bqb\u001d9sS:<gM]1nK^|'o[\u0005\u0003%&\u0013\u0011\"Q;u_^L'/\u001a3)\t\u0005!v\u000b\u0017\t\u0003\u0011VK!AV%\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%A\u001a\u0002!]|'o[3s%\u0016\u0004xn]5u_JL\bCA.b\u001b\u0005a&BA/_\u00031!\u0017n\u001d;sS\n,H/[8o\u0015\t\u0019rL\u0003\u0002a1\u00051QM\\4j]\u0016L!A\u0019/\u0003;Q\u000b7o[#yK\u000e,H/[8o/>\u00148.\u001a:SKB|7/\u001b;pefD#AA$\u0011\u0007UBT\r\u0005\u0002gS6\tqM\u0003\u0002i?\u00061A/Y:lKJL!A[4\u0003'Q\u000b7o[#yK\u000e,H/[8o\u000b:<\u0017N\\3)\u0005\r9\u0015AC1tWRKW.Z8viB\u0011an\u001e\b\u0003_V\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u0010\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0018!B:dC2\f\u0017B\u0001<t\u0003\u0019\u0001&/\u001a3fM&\u0011\u00010\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001c\b\u0006\u0002\u0003|/z\u0004\"\u0001\u0013?\n\u0005uL%!\u0002,bYV,\u0017%A@\u0002E\u0011Z\b\u0010\u001c\u0018uCN\\WM\u001d\u0018bg.$\u0016.\\3pkRT\u0014\u0007\r\u0011tK\u000e|g\u000eZ:~\u0003\u0019a\u0014N\\5u}QQ\u0011QAA\u0005\u0003\u001f\t\u0019\"a\u0006\u0011\u0007\u0005\u001d\u0001!D\u0001\u0013\u0011\u0015\u0019T\u00011\u00015Q\r\tIa\u0012\u0015\u0006\u0003\u0013!v\u000b\u0017\u0005\u00063\u0016\u0001\rA\u0017\u0015\u0004\u0003\u001f9\u0005\"\u00021\u0006\u0001\u0004!\u0007fAA\n\u000f\")A.\u0002a\u0001[\"*\u0011qC>X}\u00069A/[7f_V$XCAA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013}\u0005!Q\u000f^5m\u0013\u0011\tI#a\t\u0003\u000fQKW.Z8vi\u0006AA/[7f_V$\b%\u0001\u0007iiR\u0004(+Z:q_:\u001cX-\u0006\u0002\u00022A!\u00111GA!\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012aA:qS*!\u00111HA\u001f\u0003!\u0011Xm\u001d;fCNL(bAA \u0005\u0006)!NY8tg&!\u00111IA\u001b\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u00035AG\u000f\u001e9SKN\u0004xN\\:fA!\u001a\u0011\"!\u0013\u0011\t\u0005-\u00131L\u0007\u0003\u0003\u001bR1aFA(\u0015\u0011\t\t&a\u0015\u0002\u0005I\u001c(\u0002BA+\u0003/\n!a^:\u000b\u0005\u0005e\u0013a\u00026bW\u0006\u0014H/Y\u0005\u0005\u0003;\niEA\u0004D_:$X\r\u001f;\u0002\u001fMDW\u000f\u001e3po:<vN]6feN$B!a\u0019\u0002lA!\u0011QMA4\u001b\u0005\u0019\u0018bAA5g\n!QK\\5u\u0011\u001d\tiG\u0003a\u0001\u0003_\nqa^8sW\u0016\u00148\u000fE\u0003\u0002r\u0005eT.\u0004\u0002\u0002t)!\u0011QEA;\u0015\t\t9(\u0001\u0003kCZ\f\u0017\u0002BA>\u0003g\u0012A\u0001T5ti\u0006q1\u000f[;uI><hnV8sW\u0016\u0014H\u0003BA2\u0003\u0003Cq!a!\f\u0001\u0004\t))\u0001\u0005x_J\\WM]%e!\u0011\t9)!$\u000e\u0005\u0005%%\u0002BAF\u0003k\nA\u0001\\1oO&!\u0011qRAE\u0005\u001dIe\u000e^3hKJ\fQ\"[:M_\u000e\fGnV8sW\u0016\u0014H\u0003BAK\u00037\u0003B!!\u001a\u0002\u0018&\u0019\u0011\u0011T:\u0003\u000f\t{w\u000e\\3b]\"1\u0011Q\u0014\u0007A\u00025\fq!\u00193ee\u0016\u001c8/A\u000buQJ|w\u000fT8dC2<vN]6fe\u0016\u0013(o\u001c:\u0015\t\u0005\r\u0016\u0011\u0016\t\u0005\u0003K\n)+C\u0002\u0002(N\u0014qAT8uQ&tw\r\u0003\u0004\u0002,6\u0001\r!\\\u0001\u0002g\u0006a!/Z7pm\u0016<vN]6feR!\u00111MAY\u0011\u001d\t\u0019I\u0004a\u0001\u0003\u000b\u000bAC]3sK\u001eL7\u000f^3s\u000f\"|7\u000f\u001e+bg.\u001cHCAA8\u0003-a\u0017n\u001d;X_J\\WM]:\u0015\r\u0005m\u0016\u0011\\Au!\u0019\t\t(!\u001f\u0002>B!\u0011qXAk\u001b\t\t\tM\u0003\u0003\u0002D\u0006\u0015\u0017!B7pI\u0016d'\u0002BAd\u0003\u0013\f1a]9m\u0015\u0011\tY-!4\u0002\r\u0011,\u0007\u000f\\8z\u0015\u0011\ty-!5\u0002\u000f\u0011Lw-\u001b;bY*\u0011\u00111[\u0001\u0003C&LA!a6\u0002B\nQqk\u001c:lKJLeNZ8\t\u000f\u0005m\u0007\u00031\u0001\u0002^\u00061\u0001/Y4j]\u001e\u0004B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0004\u0003Gt\u0016a\u00013u_&!\u0011q]Aq\u0005\u0019\u0001\u0016mZ5oO\"9\u00111\u001e\tA\u0002\u00055\u0018!B8sI\u0016\u0014\b\u0003BAp\u0003_LA!!=\u0002b\nAqJ\u001d3fe&tw\rK\u0002\u0001\u0003k\u0004B!a>\u0002~6\u0011\u0011\u0011 \u0006\u0004\u0003w|\u0015AC:uKJ,w\u000e^=qK&!\u0011q`A}\u0005)\u0019uN\u001c;s_2dWM\u001d")
public class WorkersResource
extends AbstractSecuredResource
implements WorkersService,
Logging {
    @Autowired
    @Qualifier(value="workerManager")
    private final BeanWrapper<ActorRef> workerManager;
    @Autowired
    private final TaskExecutionWorkerRepository workerRepository;
    @Autowired
    private final BeanWrapper<TaskExecutionEngine> engine;
    private final Timeout timeout;
    @Context
    private final HttpResponse httpResponse;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkersResource workersResource = this;
        synchronized (workersResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private Timeout timeout() {
        return this.timeout;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public void shutdownWorkers(java.util.List<String> workers) {
        this.checkPermission(PlatformPermissions.ADMIN);
        if (workers.isEmpty()) {
            this.logger().info((Function0 & Serializable)() -> "Shutting down all workers.");
        } else {
            this.logger().info((Function0 & Serializable)() -> "Shutting down workers " + workers + ".");
        }
        CollectionConverters$.MODULE$.ListHasAsScala(workers).asScala().find((Function1 & Serializable)address -> BoxesRunTime.boxToBoolean((boolean)this.isLocalWorker(address))).foreach((Function1 & Serializable)s -> this.throwLocalWorkerError((String)s));
        this.workerRepository.listWorkers().map((Function1 & Serializable)x$1 -> (Worker)x$1._1()).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorkers$6(this, workers, worker);
            return BoxedUnit.UNIT;
        });
        ActorRef qual$1 = package$.MODULE$.ask((ActorRef)this.workerManager.get());
        WorkerManager.messages$.ShutdownWorker x$12 = new WorkerManager.messages$.ShutdownWorker(CollectionConverters$.MODULE$.ListHasAsScala(workers).asScala().toList(), true);
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$12);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$12, x$2, x$3), (Duration)this.timeout().duration());
        if (!workers.isEmpty()) {
            List shutdownWorkers = response.workers();
            this.logger().info((Function0 & Serializable)() -> "Workers " + shutdownWorkers.mkString("[", ", ", "]") + " shutdown.");
            ArrayList<String> notFound = new ArrayList<String>(workers);
            notFound.removeAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)shutdownWorkers).asJava());
            if (!notFound.isEmpty()) {
                throw new NotFoundException("Workers " + CollectionConverters$.MODULE$.ListHasAsScala(notFound).asScala().mkString("[", ", ", "]") + " not found. (Workers " + shutdownWorkers.mkString("[", ", ", "]") + " shutdown.)");
            }
            return;
        }
    }

    public void shutdownWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Worker for id " + workerId + " not found.");
        }).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorker$2(this, worker);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isLocalWorker(String address) {
        return AddressFromURIString$.MODULE$.apply(address).hasLocalScope();
    }

    private Nothing$ throwLocalWorkerError(String s) {
        throw new IllegalArgumentException("Local worker (" + s + ") cannot be shutdown.");
    }

    public void removeWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Worker for id " + workerId + " not found.");
        }).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$removeWorker$2(this, workerId, worker);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.List<String> reregisterGhostTasks() {
        this.checkPermission(PlatformPermissions.ADMIN);
        return ((TaskExecutionEngine)this.engine.get()).reregisterGhostTasks();
    }

    public java.util.List<WorkerInfo> listWorkers(Paging paging, com.xebialabs.deployit.engine.api.dto.Ordering order) {
        this.checkPermission(PlatformPermissions.ADMIN);
        Timeout timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
        ActorRef qual$1 = package$.MODULE$.ask((ActorRef)this.workerManager.get());
        WorkerManager.messages$.FetchWorkers x$1 = new WorkerManager.messages$.FetchWorkers();
        Timeout x$22 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$22, x$3), (Duration)timeout.duration());
        List workers = this.workerRepository.listWorkers().map(Function$.MODULE$.tupled((Function3 & Serializable)(w, deploymentTasks, controlTasks) -> new WorkerInfo(Predef$.MODULE$.Integer2int(w.id()), w.name(), w.address(), WorkersResource.calculateState$1(w, response.healthy(), response.incompatible(), response.draining()).toString(), Predef$.MODULE$.Integer2int(deploymentTasks), Predef$.MODULE$.Integer2int(controlTasks))));
        if ((paging == null || paging.resultsPerPage() == -1) && order == null) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getId()), (Ordering)Ordering.Int$.MODULE$)).asJava().stream().collect(Collectors.toList());
        }
        PaginationSupport$.MODULE$.addTotalCountHeader((long)workers.size(), this.httpResponse());
        int from = (paging.page() - 1) * paging.resultsPerPage();
        int to = from + paging.resultsPerPage() <= CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers).asJava().size() ? from + paging.resultsPerPage() : CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers).asJava().size();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)WorkersSorting$.MODULE$.sort((List<WorkerInfo>)workers, order).slice(from, to)).asJava();
    }

    public static final /* synthetic */ void $anonfun$shutdownWorkers$6(WorkersResource $this, java.util.List workers$1, Worker worker) {
        if (workers$1.isEmpty() || workers$1.contains(worker.address())) {
            $this.workerRepository.removeTasks(worker.id());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$shutdownWorker$2(WorkersResource $this, Worker worker) {
        String address = worker.address();
        if ($this.isLocalWorker(address)) {
            throw $this.throwLocalWorkerError(address);
        }
        ActorRef qual$1 = package$.MODULE$.ask((ActorRef)$this.workerManager.get());
        WorkerManager.messages$.ShutdownWorker x$1 = new WorkerManager.messages$.ShutdownWorker((List)new .colon.colon((Object)address, (List)Nil$.MODULE$), false);
        Timeout x$2 = $this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)$this.timeout().duration());
        List shutdownWorkers = response.workers();
        $this.logger().info((Function0 & Serializable)() -> "Workers " + shutdownWorkers.mkString("[", ", ", "]") + " shutdown.");
        if (!response.workers().contains((Object)address)) {
            throw new NotFoundException("Worker " + address + " not found.");
        }
    }

    public static final /* synthetic */ void $anonfun$removeWorker$2(WorkersResource $this, Integer workerId$2, Worker worker) {
        ActorRef x$3;
        Timeout x$2;
        WorkerManager.messages$.FetchWorkers x$1;
        ActorRef qual$1 = package$.MODULE$.ask((ActorRef)$this.workerManager.get());
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)(x$1 = new WorkerManager.messages$.FetchWorkers()), x$2 = $this.timeout(), x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)$this.timeout().duration());
        List active = (List)response.draining().$plus$plus((IterableOnce)response.healthy());
        if (active.contains((Object)worker.address())) {
            throw new IllegalArgumentException("Worker for id " + workerId$2 + " is still active, cannot be removed.");
        }
        $this.workerRepository.removeTasks(workerId$2);
        $this.workerRepository.removeWorker(workerId$2);
    }

    private static final Enumeration.Value calculateState$1(Worker w, List healthy, List incompatible, List draining) {
        if (healthy.contains((Object)w.address())) {
            return WorkerState$.MODULE$.CONNECTED();
        }
        if (incompatible.contains((Object)w.address())) {
            return WorkerState$.MODULE$.INCOMPATIBLE();
        }
        if (draining.contains((Object)w.address())) {
            return WorkerState$.MODULE$.DRAINING();
        }
        return WorkerState$.MODULE$.DISCONNECTED();
    }

    public WorkersResource(@Autowired @Qualifier(value="workerManager") BeanWrapper<ActorRef> workerManager, @Autowired TaskExecutionWorkerRepository workerRepository, @Autowired BeanWrapper<TaskExecutionEngine> engine, @Value(value="${xl.tasker.askTimeout:10 seconds}") String askTimeout) {
        this.workerManager = workerManager;
        this.workerRepository = workerRepository;
        this.engine = engine;
        Logging.$init$((Logging)this);
        this.timeout = new Timeout(HoconDurationConverter$.MODULE$.convert(askTimeout));
        this.httpResponse = null;
    }
}

