package com.xebialabs.deployit.core.rest.api.reports

import java.net.URL

import org.apache.commons.io.IOUtils
import org.apache.poi.ss.usermodel._
import org.apache.poi.xssf.usermodel.XSSFWorkbook
import org.slf4j.{Logger, LoggerFactory}

object ExcelElements {
  val Log: Logger = LoggerFactory.getLogger(this.getClass)

  def insertImage(image: URL, workbook: Workbook, sheet: Sheet): Unit = {
    val imageBytes = IOUtils.toByteArray(image)
    val pictureIdx = workbook.addPicture(imageBytes, Workbook.PICTURE_TYPE_PNG)
    val helper = workbook.getCreationHelper
    val drawing = sheet.createDrawingPatriarch
    val anchor = helper.createClientAnchor
    anchor.setCol1(4)
    anchor.setRow1(2)
    val pict = drawing.createPicture(anchor, pictureIdx)
    pict.resize()
  }

  def addCell(row: Row, workbook: XSSFWorkbook): Unit = {
    val cellStyle = ExcelStyle.getCellStyle(workbook)
    cellStyle.setFont(ExcelStyle.getBoldFont(workbook))
    for (i <- 1 until 9) {
      if (row.getCell(i) == null) {
        val cell = row.createCell(i)
        cell.setCellStyle(cellStyle)
      }
    }
  }

}

