package com.xebialabs.deployit.core.rest.api

import java.util

import ai.digital.deploy.sql.http.enricher.PaginationService
import ai.digital.deploy.sql.model.{ActiveUserSession, UserSessionsOverview}
import com.xebialabs.deployit.core.api.SessionService
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource
import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}
import com.xebialabs.deployit.repository.XldSessionRepository
import com.xebialabs.deployit.security.permission.PlatformPermissions.{EDIT_SECURITY, VIEW_SECURITY}
import jakarta.ws.rs.core.Context
import org.jboss.resteasy.spi.HttpResponse
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
class SessionServiceImpl(xldSessionRepository: XldSessionRepository, paginationService: PaginationService)
  extends AbstractSecuredResource with SessionService {
  @Context val response: HttpResponse = null

  override def getActiveSessions(principalPattern: String,
                                 paging: Paging,
                                 order: Ordering): util.List[ActiveUserSession] = {
    checkPermissions(EDIT_SECURITY, VIEW_SECURITY)

    val principalPatternOption = Option(principalPattern).getOrElse("")
    paginationService.addPagingHeaderIfNeeded(
      paginationService.toSetHeader(response),
      () => xldSessionRepository.count(principalPatternOption),
      paging
    )
    xldSessionRepository.findAll(principalPatternOption, paging, order).asJava
  }

  override def getSessionsOverview: UserSessionsOverview = {
    checkPermissions(EDIT_SECURITY, VIEW_SECURITY)
    xldSessionRepository.getSessionSummary
  }
}
